package edu.sc.seis.gee.task;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class VersionTask implements GUITask {

    private static String cvsversion = "$Revision: 15228 $";

    private static String datetime = edu.sc.seis.gee.BuildVersion.getDate();

    private static String state = "$State$";

    private static String version = edu.sc.seis.gee.BuildVersion.getVersion();

    public void invoke() {}

    public void destroy() {}

    public JComponent getMoreOptionsGUI() {
        return null;
    }

    public JComponent getGUI() throws Exception {
        if(panel == null)
            createGUI();
        return panel;
    }

    public boolean hasMoreOptions() {
        return false;
    }

    public void createGUI() {
        panel = new JPanel();
        GridBagLayout bagLayout = new GridBagLayout();
        panel.setLayout(bagLayout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1;
        constraints.weighty = 1;
        constraints.gridx = 3;
        constraints.gridy = 6;
        JLabel headerLabel = new JLabel(" Global Earthquake Explorer ");
        bagLayout.setConstraints(headerLabel, constraints);
        panel.add(headerLabel);
        constraints.gridy = constraints.gridy + 1;
        JLabel authorLabelone = new JLabel("A product of the University of South Carolina");
        bagLayout.setConstraints(authorLabelone, constraints);
        panel.add(authorLabelone);
        constraints.gridy = constraints.gridy + 1;
        JLabel authorLabeloneb = new JLabel("and the IRIS Consortium,");
        bagLayout.setConstraints(authorLabeloneb, constraints);
        panel.add(authorLabeloneb);
        constraints.gridy = constraints.gridy + 1;
        JLabel authorLabeltwo = new JLabel("created by H. Philip Crotwell, Thomas J. Owens,");
        bagLayout.setConstraints(authorLabeltwo, constraints);
        panel.add(authorLabeltwo);
        constraints.gridy = constraints.gridy + 1;
        JLabel authorLabelthree = new JLabel(" Srinivasa R. Telukutla, Charles Groves,");
        bagLayout.setConstraints(authorLabelthree, constraints);
        panel.add(authorLabelthree);
        constraints.gridy = constraints.gridy + 1;
        JLabel authorLabelfour = new JLabel(" Philip Oliver-Paull, and Evan Owens.");
        bagLayout.setConstraints(authorLabelfour, constraints);
        panel.add(authorLabelfour);
        constraints.gridy = constraints.gridy + 1;
        JLabel artLabel = new JLabel(" Splash Artwork \"Apple\" by Charlotte Crotwell");
        bagLayout.setConstraints(artLabel, constraints);
        panel.add(artLabel);
        constraints.gridy++;
        JLabel verLabel = new JLabel(" Version No. " + version);
        bagLayout.setConstraints(verLabel, constraints);
        panel.add(verLabel);
        constraints.gridy++;
        JLabel dateLabel = new JLabel(" Last Modified on "
                + datetime.substring(1, datetime.length() - 1));
        bagLayout.setConstraints(dateLabel, constraints);
        panel.add(dateLabel);
        constraints.gridy++;
        JLabel cvsverLabel = new JLabel(" CVS Version "
                + cvsversion.substring(1, cvsversion.length() - 1));
        bagLayout.setConstraints(cvsverLabel, constraints);
        panel.add(cvsverLabel);
        constraints.gridy++;
        JLabel stateLabel = new JLabel(" CVS "
                + state.substring(1, state.length() - 1));
        bagLayout.setConstraints(stateLabel, constraints);
        panel.add(stateLabel);
        constraints.gridy++;
        JLabel bugLabel = new JLabel("Please send comments, bug reports and criticism to");
        panel.add(bugLabel, constraints);
        constraints.gridy++;
        JLabel bugLabel2 = new JLabel("geebugs@seis.sc.edu");
        panel.add(bugLabel2, constraints);
    }

    public void configure(Map params) {}

    public static String getVersion() {
        return version;
    }

    public static String getVersionDate() {
        return datetime;
    }

    public static String getCVSVersion() {
        return cvsversion;
    }

    private JPanel panel;
}// VersionTask
