/**
 * UpdateCheckerTask.java
 *
 * @author Created by Omnicore CodeGuide
 */

package edu.sc.seis.gee.task;
import java.util.Map;
import org.apache.log4j.Logger;
import edu.sc.seis.fissuresUtil.cache.JobTracker;
import edu.sc.seis.fissuresUtil.cache.WorkerThreadPool;
import edu.sc.seis.fissuresUtil.chooser.UpdateCheckerJob;
import edu.sc.seis.gee.NetworkGateKeeper;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.configurator.DefaultParamNames;



public class UpdateCheckerTask implements Task {
    /**
     * Called when a task is to be executed, usually by a menu or toolbar
     * selection for simple tasks.
     *
     *
     * @exception Exception if an error occurs
     */
    public void invoke() throws Exception {
        UpdateCheckerJob job = new UpdateCheckerJob((String)params.get(DefaultParamNames.TASK_NAME),
                                                    "GEE",
                                                    VersionTask.getVersion(),
                                                    updateURL,
                                                    GUI_BASED,
                                                    showNoUpdate);
        if ( ! NetworkGateKeeper.isOffline()) {
            JobTracker.getTracker().add(job);
            WorkerThreadPool.getDefaultPool().invokeLater(job);
        }
    }

    /**
     * Configures a <code>Task</code> with any needed parameters. The Task
     * should have default values for as many things as possible, but can
     * throw a ConfigureException if a required parameter is missing.
     *
     * @param params a <code>Map</code> value
     * @exception ConfigurationException if an error occurs
     */
    public void configure(Map params) throws ConfigurationException {
        this.params = params;
        if(params.containsKey("showNoUpdate")){
            showNoUpdate =
                Boolean.valueOf((String)params.get("showNoUpdate")).booleanValue();
        }
        if(params.containsKey("updateURL")){
            updateURL = (String)params.get("updateURL");
        }
    }

    /**
     * Called when reset is invoked on gee or if this task is no longer being used
     *
     */
    public void destroy() {
        // TODO
    }

    Map params;

    boolean GUI_BASED = true;

    boolean showNoUpdate = true;

    String updateURL = "http://www.seis.sc.edu/GEE/Dynamic/UpdateChecker.xml";

    static Logger logger = Logger.getLogger(UpdateCheckerTask.class);
}




