package edu.sc.seis.gee.task;

import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;

import org.apache.log4j.Category;

import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitRangeImpl;
import edu.sc.seis.fissuresUtil.chooser.ThreadSafeDecimalFormat;
import edu.sc.seis.fissuresUtil.chooser.ThreadSafeSimpleDateFormat;
import edu.sc.seis.fissuresUtil.display.TimeScaleCalc;
import edu.sc.seis.fissuresUtil.display.UnitDisplayUtil;
import edu.sc.seis.fissuresUtil.display.drawable.TimeAmpLabel;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseAdapter;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseEvent;

public class TimeAmpLabelTask extends SDMouseAdapter implements Task{

    public void configure(Map params){}

    public void invoke() { GlobalToolBar.add(this); }

    public void destroy(){ GlobalToolBar.remove(this); }

    public void mouseMoved(SDMouseEvent me){
        label.setText(formatInfo(me.getTime(),me.getAmp(),
                                 me.getDisplay().getAmpConfig().getAmp()));
        me.getDisplay().repaint();
    }

    public void mouseEntered(SDMouseEvent me){
        me.getDisplay().add(label);
        mouseMoved(me);
    }

    public void mouseExited(SDMouseEvent me){
        me.getDisplay().remove(label);
        me.getDisplay().repaint();
    }

    private TimeAmpLabel label = new TimeAmpLabel();

    private String[] formatInfo(MicroSecondDate newTime, QuantityImpl newAmp, UnitRangeImpl ampRange){
        if(curAmpRange != ampRange){
            currentFormatter = defaultFormatter;
            double absMax = Math.abs(ampRange.getMaxValue());
            double absMin = Math.abs(ampRange.getMinValue());
            double maxVal;
            if(absMax/10 > absMin){
                maxVal = absMax;
            }else{
                maxVal = absMin;
            }
            if(maxVal >=1){
                StringBuffer formatPattern = new StringBuffer(" 0.00;-0.00");
                while(maxVal > 10){
                    formatPattern.insert(1,"0");
                    formatPattern.insert(formatPattern.length() - 4, "0");
                    maxVal /= 10;
                }
                currentFormatter = new ThreadSafeDecimalFormat(formatPattern.toString());
            }
            curAmpRange = ampRange;
        }
        double newAmpVal = newAmp.getValue();
        String amp = "";
        if(newAmpVal != Double.NaN){
            String ampString = "Amplitude:";
            ampString += currentFormatter.format(newAmpVal);
            amp = ampString+" "+UnitDisplayUtil.getNameForUnit(newAmp.getUnit());
        }
        String time = "";
        calendar.setTime(newTime);
        if(TimeScaleCalc.roundTheEpoch.intersects(newTime))
            output = relativeOutput;
        else
            output = fullOutput;
        StringBuffer timeBuffer = new StringBuffer(amp.length());
        if(output.format(calendar.getTime()).length() == 21)
            timeBuffer.append(output.format(calendar.getTime()) + "00");
        else if(output.format(calendar.getTime()).length() == 22)
            timeBuffer.append(output.format(calendar.getTime()) + "0");
        else
            timeBuffer.append(output.format(calendar.getTime()));
        int numSpaces = amp.length() - timeBuffer.length() - 10;//Amplitude: is 10 chars
        if(numSpaces <0)
            numSpaces = 0;
        StringBuffer spaces = new StringBuffer(numSpaces);
        for (int i = 0; i < numSpaces; i++){
            spaces.append(" ");
        }
        timeBuffer.insert(0, spaces);
        if(output == relativeOutput)
            timeBuffer.insert(0, "Relative Time:");
        else
            timeBuffer.insert(0, "Time:");
        time = timeBuffer.toString();
        String[] timeAmp = {time, amp};
        return timeAmp;
    }

    private UnitRangeImpl curAmpRange;

    public static final ThreadSafeDecimalFormat defaultFormatter = new ThreadSafeDecimalFormat(" 0.000E0;-0.000E0");

    private ThreadSafeDecimalFormat currentFormatter;

    private ThreadSafeSimpleDateFormat fullOutput = new ThreadSafeSimpleDateFormat("HH:mm:ss.SSS MM/dd/yyyy");

    private ThreadSafeSimpleDateFormat output = fullOutput;

    private ThreadSafeSimpleDateFormat relativeOutput = new ThreadSafeSimpleDateFormat("mm:ss.SSS");

    private Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));

    private static Category logger = Category.getInstance(TimeAmpLabelTask.class.getName());
}// TimeAmpLabelTask
