package edu.sc.seis.gee.task;

import java.util.Map;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.configurator.DefaultParamNames;

/**
 * Task.java
 *
 *
 * Created: Thu Nov 29 22:50:35 2001
 *
 * @author <a href="mailto:">Philip Crotwell</a>
 * @version
 */

public interface Task extends DefaultParamNames {

    /**
     * Configures a <code>Task</code> with any needed parameters. The Task
     * should have default values for as many things as possible, but can
     * throw a ConfigureException if a required parameter is missing.
     *
     * @param params a <code>Map</code> value
     * @exception ConfigurationException if an error occurs
     */
    public void configure(Map params) throws ConfigurationException;

    /**
     * Called when a task is to be executed, usually by a menu or toolbar
     * selection for simple tasks.
     *
     *
     * @exception Exception if an error occurs
     */
    public void invoke() throws Exception;

    /**
     * Called when reset is invoked on gee or if this task is no longer being used
     *
     */
    public void destroy();

}// Task
