/**
 * TabbedTask.java
 * 
 * @author Created by Omnicore CodeGuide
 */
package edu.sc.seis.gee.task;

import java.util.Map;
import java.util.StringTokenizer;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.FrameManager;

public class TabbedTask implements Task {

    public void configure(Map params) {
        tasks = (String)params.get("TabbedTasks");
        taskName = (String)params.get(TASK_NAME);
        if(params.containsKey("MakeFrame")) {
            makeFrame = Boolean.valueOf((String)params.get("MakeFrame"))
                    .booleanValue();
        }
    }

    public void invoke() throws Exception {
        if(makeFrame) {
            FrameManager.getManager().createNewMother(taskName);
            makeFrame = false;
        }
        TaskAction first = null;
        CommonAccess c = CommonAccess.getCommonAccess();
        StringTokenizer tokenizer = new StringTokenizer(tasks, ",");
        int tokens = tokenizer.countTokens();
        for(int i = 0; i < tokens; i++) {
            String task = tokenizer.nextToken().trim();
            TaskAction taskAction = c.getTaskAction(task);
            if(taskAction != null) {
                taskAction.invoke(true);
            } else {
                FrameManager fm = FrameManager.getManager();
                fm.createNewTab(fm.getCurrentFrame(), task);
            }
            if(first == null) {
                first = taskAction;
                first.checkDisplayLocation();
            }
        } // end of while ()
    }

    public void destroy() {}

    private String tasks, taskName;

    private boolean makeFrame = false;
}