package edu.sc.seis.gee.task;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Map;
import javax.swing.JFileChooser;
import edu.sc.seis.fissuresUtil.chooser.FileNameFilter;
import edu.sc.seis.fissuresUtil.display.SeismogramContainer;
import edu.sc.seis.fissuresUtil.display.SeismogramContainerFactory;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.sound.FissuresToWAV;
import edu.sc.seis.fissuresUtil.time.RangeTool;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.dataSetBrowser.DataSetBrowser;

/**
 * SoundExport.java Created: Wed Feb 19 21:00:13 2003
 * 
 * @author <a href="mailto:crotwell@maple.local.">Philip Crotwell </a>
 * @version 1.0
 */
public class SoundExport implements Task {

    public SoundExport() {} // SoundExport constructor

    public void configure(Map params) throws ConfigurationException {
        this.params = params;
    }

    public void invoke() throws Exception {
        showGUI();
    }

    public void destroy() {}

    void showGUI() throws ConfigurationException {
        final JFileChooser fc = new JFileChooser();
        String extensions[] = new String[1];
        extensions[0] = "wav";
        fc.setFileFilter(new FileNameFilter(extensions));
        fc.setDialogTitle("Save WAV file");
        fc.setSelectedFile(new File("unknown.wav"));
        CommonAccess commonAccess = CommonAccess.getCommonAccess();
        String browserId = (String)params.get("datasetbrowser");
        TaskAction browserAction = CommonAccess.getCommonAccess()
                .getTaskAction(browserId);
        DataSetBrowser browser = (DataSetBrowser)browserAction.getTask();
        int returnVal = fc.showSaveDialog(CommonAccess.getCommonAccess()
                .getMainFrame());
        DataSetSeismogram seis;
        if(params.containsKey("datasetbrowser")) {
            DataSetSeismogram[] dsToSave = browser.getSelectedSeismograms();
            seis = dsToSave[0];
        } else {
            seis = null;
        } // end of else
        if(returnVal == JFileChooser.APPROVE_OPTION) {
            File file = fc.getSelectedFile();
            try {
                file.createNewFile(); // make sure it exists
                DataOutputStream fos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                SeismogramContainer container = SeismogramContainerFactory.create(seis);
                FissuresToWAV toWav = new FissuresToWAV(container, 1200);
                toWav.writeWAV(fos,
                               RangeTool.getFullTime(container.getSeismograms()));
                fos.close();
            } catch(Exception e) {
                GlobalExceptionHandler.handle("Problem saving WAV file.", e);
            }
        } else {
            //log.append("Open command cancelled by user.");
        }
    }

    Map params;
} // SoundExport
