package edu.sc.seis.gee.task;

/**
 * ShowEventsTask.java
 * 
 * 
 * Created: Wed Jan 16 10:37:36 2002
 * 
 * @author <a href="mailto:">Srinivasa Telukutla</a>
 * @version
 */
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Category;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.sc.seis.fissuresUtil.display.EQDataEvent;
import edu.sc.seis.fissuresUtil.display.EventDataListener;
import edu.sc.seis.fissuresUtil.display.EventTableModel;
import edu.sc.seis.gee.configurator.ConfigurationException;

public class ShowEventsTask implements GUITask, EventDestination {

    public ShowEventsTask() {
        tableModel = new EventTableModel();
        eventTable = new JTable(tableModel);
        eventTable.setRowSelectionAllowed(true);
        eventTable.setColumnSelectionAllowed(false);
        eventTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        eventTable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        selectionModel = eventTable.getSelectionModel();
        tableModel.addEventDataListener(new EventDataListener() {

            public void eventDataChanged(EQDataEvent eqDataEvent) {}

            public void eventDataAppended(EQDataEvent eqDataEvent) {}

            public void eventDataCleared() {
                selectionModel.clearSelection();
            }
        });
    }

    /**
     * Gets the "More Options" GUI component.
     */
    public JComponent getMoreOptionsGUI() {
        return null;
    }

    /**
     * Gets the GUI for this Task. Used for interacting with the user before and
     * after invoking this Task's action.
     */
    public JComponent getGUI() throws Exception {
        if(panel == null) {
            initGUI();
        }
        return panel;
    }

    /**
     * True if this GUI has a "more options" funtionality. More options appear
     * in a separate panel below the main gui, and can be shown/hidden with a
     * "Show More Options" and "Hide More Options" button that is provided
     * automatically is this return true.
     */
    public boolean hasMoreOptions() {
        return false;
    }

    public void configure(java.util.Map params) throws ConfigurationException {}

    public void invoke() {}

    public void destroy() {}

    public void updateEvents(EventAccessOperations[] events) {
        if(events != null) {
            tableModel.updateEvents(events);
        } // end of if (events != null)
    }

    public void appendEvents(EventAccessOperations[] events) {
        if(events != null) {
            tableModel.appendEvents(events);
        } // end of if (events != null)
    }

    public EventAccessOperations[] getSelectedEvents() {
        int min = selectionModel.getMinSelectionIndex();
        int max = selectionModel.getMaxSelectionIndex();
        List selected = new ArrayList();
        for(int i = min; i <= max; i++) {
            if(selectionModel.isSelectedIndex(i)) {
                selected.add(tableModel.getEventForRow(i));
            }
        }
        return (EventAccessOperations[])selected.toArray(new EventAccessOperations[0]);
    }

    protected void initGUI() {
        // must not be initialized
        JPanel contentPane = new JPanel();
        JPanel endPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        java.awt.Dimension dimension = new java.awt.Dimension(1000, 400);
        contentPane.setPreferredSize(dimension);
        contentPane.setMinimumSize(dimension);
        setColumnSizes();
        JScrollPane jsp = new JScrollPane(eventTable);
        contentPane.add(jsp, BorderLayout.CENTER);
        contentPane.add(endPane, BorderLayout.SOUTH);
        panel = contentPane;
    }

    public void setColumnSizes() {
        int columnCount = tableModel.getColumnCount();
        for(int counter = 0; counter < columnCount; counter++) {
            String columnName = tableModel.getColumnName(counter);
            int width = 50;
            if(columnName.equals("Region"))
                width = 250;
            else if(columnName.equals("Origin Time"))
                width = 200;
            else if(columnName.equals("Latitude"))
                width = 80;
            else if(columnName.equals("Longitude"))
                width = 80;
            else if(columnName.equals("Depth"))
                width = 100;
            else if(columnName.equals("Magnitude"))
                width = 80;
            else if(columnName.equals("Catalog"))
                width = 100;
            else if(columnName.equals("Contributor"))
                width = 100;
            eventTable.getColumnModel()
                    .getColumn(counter)
                    .setPreferredWidth(width);
            eventTable.getColumnModel().getColumn(counter).setMinWidth(width);
        }
    }

    public EventTableModel getEventTableModel() {
        return tableModel;
    }

    public ListSelectionModel getEventSelectionModel() {
        return selectionModel;
    }

    JPanel panel = null;

    EventListenerList listenerList = new EventListenerList();

    protected EventTableModel tableModel;

    private ListSelectionModel selectionModel;

    JTable eventTable;

    static Category logger = Category.getInstance(ShowEventsTask.class.getName());
}// ShowEventsTask
