package edu.sc.seis.gee.task;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;


/**
 * @author oliverpa
 * Created on Aug 24, 2004
 */
public class SeismogramDisplayOutputTask extends DisplayOutputTask {

    private Map configParams;
    private ColumnSeismogramTask colSeisTask;

    public SeismogramDisplayOutputTask(){
        dialogueTitle = "Save Seismogram Display to PNG";
    }
    
    public void configure(Map params) throws ConfigurationException {
        configParams = params;
        if(params.containsKey("colSeisTask")) {
            String taskId = (String)params.get("colSeisTask");
            TaskAction taskAction = CommonAccess.getCommonAccess()
                    .getTaskAction(taskId);
            colSeisTask = (ColumnSeismogramTask)taskAction.getTask();
        } else {
            throw new ConfigurationException("no colSeisTask configured");
        }
    }

    protected void save(File file) throws IOException {
        SeismogramDisplay display = colSeisTask.getDisplay();
        display.outputToPNG(file, display.getSize());
    }
}
