package edu.sc.seis.gee.task;
import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import edu.sc.seis.fissuresUtil.display.RecordSectionDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.registrar.LayoutScaler;



public class RecordSectionTask extends DisplayMakerTask{

    public SeismogramDisplay makeDisplay() {
        RecordSectionDisplay recSec = getNewDisplay();
        sliderPanel = new JPanel(new BorderLayout());
        JLabel size = new JLabel("Size", JLabel.CENTER);
        sliderPanel.add(size, BorderLayout.NORTH);
        sliderPanel.add(new LayoutScaler(recSec));
        sliderPanel.setBorder(BorderFactory.createEtchedBorder());
        return recSec;
    }

    protected RecordSectionDisplay getNewDisplay(){
        return new RecordSectionDisplay();
    }

    public boolean needsEventInformation() {
        return true;
    }


    public JPanel getSliderPanel(){
        return sliderPanel;
    }

    public void destroy(){  }

    private JPanel sliderPanel;
}

