package edu.sc.seis.gee.task;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.AbstractHandler;

/**
 * ProjectChoice.java Created: Wed Jan 15 09:40:35 2003
 * 
 * @author <a href="mailto:crotwell@owl.seis.sc.edu">Philip Crotwell </a>
 * @version 1.0
 */
public class ProjectChoice extends JLayeredPane implements SAXTask {

    public void configure(Map configParams) {
        this.params = configParams;
    }

    public void invoke() throws Exception {
        String imageName = (String)params.get("background");
        URL imgURL = getClass().getClassLoader().getResource(imageName);
        ImageIcon imageIcon = new ImageIcon(imgURL);
        JLabel imageLabel = new JLabel(imageIcon);
        add(imageLabel, BACKGROUND_LAYER);
        imageLabel.setBounds(0,
                             0,
                             imageIcon.getIconWidth(),
                             imageIcon.getIconHeight());
        int y = 110;//Y Position is cumulative starting below the banner
        int radiusSquared = GLOBE_RADIUS * GLOBE_RADIUS;
        Iterator it = choices.iterator();
        while(it.hasNext()) {
            SelectionImage si = new SelectionImage((Choice)it.next());
            int nextPosition = y + si.getHeight() + 15;
            int centerDist = nextPosition - GLOBE_CENTER.y;
            if(y >= GLOBE_CENTER.y) {
                centerDist -= si.getHeight() + 15;
            }
            int x = (int)Math.sqrt(radiusSquared - centerDist * centerDist) + 5;
            add(si, CHOICE_LAYER);
            si.setBounds(x, y, si.getWidth(), si.getHeight());
            y = nextPosition;
        }
        JLabel version = new JLabel(VersionTask.getVersion());
        add(version, CHOICE_LAYER);
        version.setSize(version.getPreferredSize());
        version.setBounds(getWidth() - 15 - version.getWidth(), getHeight() - 5
                - version.getHeight(), version.getWidth(), version.getHeight());
    }

    public void destroy() {}

    private static Integer CHOICE_LAYER = new Integer(1);

    private static Integer BACKGROUND_LAYER = JLayeredPane.DEFAULT_LAYER;

    private int GLOBE_RADIUS = 330;

    private Point GLOBE_CENTER = new Point(-8, 424);

    private Map params;

    private final class ChoiceHandler extends AbstractHandler {

        private ChoiceHandler(XMLReader parser, AbstractHandler parent) {
            super(parser, parent);
        }

        public void endElement(String namespaceURI,
                               String localName,
                               String qName) throws SAXException {
            lastParsedString = lastParsedString.trim();
            if(localName.equals("choice")) {
                if(cur.imageURL == null || cur.description == null
                        || cur.taskId == null) {
                    throw new SAXException("Poorly formed choice!");
                } else {
                    choices.add(cur);
                }
            } else if(localName.equals("imageURL")) {
                cur.imageURL = lastParsedString;
            } else if(localName.equals("description")) {
                cur.description = lastParsedString.replaceAll("\\s+", " ");
            } else if(localName.equals("taskId")) {
                cur.taskId = lastParsedString;
            } else if(localName.equals("complexValue")) {
                super.endElement(namespaceURI, localName, qName);
            }
            lastParsedString = "";
        }

        public void characters(char[] ch, int start, int length) {
            lastParsedString += new String(ch, start, length);
        }

        public void startElement(String uri,
                                 String localName,
                                 String qName,
                                 Attributes attributes) {
            if(localName.equals("choice")) {
                cur = new Choice();
            }
        }

        private String lastParsedString = "";

        private Choice cur;
    }

    private List choices = new ArrayList();

    private class Choice {

        public String imageURL, description, taskId;
    }

    class SelectionImage extends JLabel implements MouseListener {

        public SelectionImage(Choice cho) {
            String deadImageName = cho.imageURL;
            String taskId = cho.taskId;
            String description = cho.description;
            URL url = getClass().getClassLoader().getResource(deadImageName);
            deadImage = new ImageIcon(url);
            if(!taskId.equals("seperator")) {
                url = getClass().getClassLoader()
                        .getResource(getHighlightName(deadImageName));
                highlightedImage = new ImageIcon(url);
                this.val = taskId;
                this.text = description;
                addMouseListener(this);
            }
            setIcon(deadImage);
            int height = deadImage.getIconHeight();
            if(height < 60) {
                height = 35;
            } else {
                height = 70;
            }
            int width = deadImage.getIconWidth();
            if(width < 30) {
                width = 30;
            }
            setSize(new Dimension(width, height));
        }

        public void mouseEntered(MouseEvent e) {
            setIcon(highlightedImage);
            setToolTipText(text);
        }

        public Point getToolTipLocation(MouseEvent e) {
            return new Point(0, getSize().height);
        }

        public String getHighlightName(String deadName) {
            return deadName.replaceFirst("un", "");
        }

        public void mouseReleased(MouseEvent e) {}

        public void mouseClicked(MouseEvent e) {
            CommonAccess c = CommonAccess.getCommonAccess();
            TaskAction t = c.getTaskAction(val);
            t.actionPerformed(null);
        }

        public void mouseExited(MouseEvent e) {
            setIcon(deadImage);
        }

        public void mousePressed(MouseEvent e) {}

        private ImageIcon deadImage, highlightedImage;

        private String val, text;
    }

    public AbstractHandler getConfigureHandler(String name,
                                               XMLReader parser,
                                               AbstractHandler parent) {
        return new ChoiceHandler(parser, parent);
    }
} // ProjectChoice
