package edu.sc.seis.gee.task;
import java.util.Map;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;



/**
 * PlottableLoadTask.java
 *
 * @author Created by Charlie Groves
 */

public class PlottableLoadTask implements Task{


    public void configure(Map params) throws ConfigurationException {
        CommonAccess commonAccess = CommonAccess.getCommonAccess();
        String taskId = (String)params.get("plottableTask");
        TaskAction taskAction = commonAccess.getTaskAction(taskId);
        plottableTask = (PlottableTask) taskAction.getTask();
        if(plottableTask == null) {
            throw new ConfigurationException("Invalid configuration, plottableLoadTask requires a plottableTask");
        }
    }

    public void invoke() throws Exception { plottableTask.loadData(); }

    public void destroy() { }

    private PlottableTask plottableTask;

    private ChannelChooserTask channelChooserTask = null;
}

