/**
 * PlottableEventSelection.java
 *
 * @author Created by Omnicore CodeGuide
 */

package edu.sc.seis.gee.task;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import java.util.Map;
import edu.sc.seis.fissuresUtil.display.PlottableDisplay;
import edu.sc.seis.fissuresUtil.display.drawable.EventFlag;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;



public class PlottableEventSelection implements Task{

    public void invoke() throws Exception { }

    public void destroy() {}

    public void configure(Map params) throws ConfigurationException {
        if(params.containsKey("PlottableSelectionTask")){
            final TaskAction selectionTA = CommonAccess.getCommonAccess().getTaskAction((String)params.get("PlottableSelectionTask"));
            if(params.containsKey("PlottableTask")){
                TaskAction plotTA = CommonAccess.getCommonAccess().getTaskAction((String)params.get("PlottableTask"));
                PlottableTask pt = (PlottableTask)plotTA.getTask();
                final PlottableDisplay disp = pt.getDisplay();
                disp.addMouseMotionListener(new MouseMotionListener(){
                            public void mouseDragged(MouseEvent e) {}

                            public void mouseMoved(MouseEvent e) {
                                Iterator it = disp.getEvents().iterator();
                                while(it.hasNext()){
                                    EventFlag cur = (EventFlag)it.next();
                                    if(cur.getTitleLoc().contains(e.getX(), e.getY())){
                                        disp.getTempSelection().set(cur.getEventCoverage());
                                        disp.repaint();
                                        return;
                                    }
                                }
                                disp.getTempSelection().setXY(-1,-1, 0);
                                disp.repaint();
                            }
                        });
                disp.addMouseListener(new MouseAdapter(){
                            public void mouseClicked(MouseEvent e){
                                Iterator it = disp.getEvents().iterator();
                                while(it.hasNext()){
                                    EventFlag cur = (EventFlag)it.next();
                                    if(cur.getTitleLoc().contains(e.getX(), e.getY())){
                                        selectionTA.invoke(false);
                                        disp.placeTempSelection();
                                        return;
                                    }
                                }
                            }
                        });
            }else{
                throw new ConfigurationException("PlottableEventSelection requires a PlottableTask in its configuation");
            }
        }else{
            throw new ConfigurationException("PlottableEventSelection requires a PlottableSelectionTask in its configuation");
        }
    }
}
