/**
 * PlottableArrowTask.java
 *
 * @author Created by Omnicore CodeGuide
 */

package edu.sc.seis.gee.task;
import java.util.Map;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;



public class PlottableArrowTask implements Task{
    public void configure(Map params) throws ConfigurationException {
        CommonAccess commonAccess = CommonAccess.getCommonAccess();
        String taskId = (String)params.get("plottableTask");
        TaskAction taskAction = commonAccess.getTaskAction(taskId);
        plottableTask = (PlottableTask) taskAction.getTask();
        if(plottableTask == null) {
            throw new ConfigurationException("Invalid configuration, plottableTask in plottableArrow must be set");
        }
    }

    public void invoke() throws Exception {
        plottableTask.setPlottableTool(this);

    }

    public void destroy() {}

    private PlottableTask plottableTask;
}

