/**
 * PlaceholderImage.java
 *
 * @author Created by Omnicore CodeGuide
 */

package edu.sc.seis.gee.task;

import java.awt.FlowLayout;
import java.net.URL;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import edu.sc.seis.gee.configurator.ConfigurationException;

public class PlaceholderImage implements GUITask{
    public JComponent getGUI() throws ConfigurationException {
        if (panel == null) {
            panel = generateImagePanel();
        }
        return panel;
    }

    /** Gets the "More Options" GUI component.
     */
    public JComponent getMoreOptionsGUI() {
        // TODO
        return null;
    }

    /** Gets the GUI for this Task. Used for interacting with the user
     before and after invoking this Task's action.
     */
    public void invoke() throws Exception {
        // TODO
    }

    /** True if this GUI has a "more options" funtionality. More options
     *  appear in a separate panel below the main gui, and can be shown/hidden
     *  with a "Show More Options" and "Hide More Options" button that is
     *  provided automatically is this return true.
     */
    public boolean hasMoreOptions() {
        // TODO
        return false;
    }


    public void destroy() {
        panel = null;
    }

    public void configure(Map params) throws ConfigurationException {
        this.params = params;
        if(params.containsKey("image")){
            String imageName = (String)params.get("image");
            imageURL = getClass().getClassLoader().getResource(imageName);
        }else{
            throw new ConfigurationException("A placeholder image task requires an image in its configuration with the key 'image'");
        }
    }

    public JComponent generateImagePanel(){
        JPanel panel = new JPanel(new FlowLayout(FlowLayout.LEFT));
        ImageIcon image = new ImageIcon(imageURL);
        JLabel label = new JLabel(image);
        panel.add(label);
        return panel;
    }

    JComponent panel = null;

    URL imageURL;

    Map params;
}

