/**
 * PhaseTimeSetter.java
 */
package edu.sc.seis.gee.task;

import java.util.Map;
import edu.sc.seis.fissuresUtil.display.registrar.PhaseAlignedTimeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.TimeConfig;
import edu.sc.seis.gee.configurator.ConfigurationException;

public class PhaseTimeSetter extends TimeSetterTask {

    public void configure(Map params) throws ConfigurationException {
        super.configure(params);
        if(params.containsKey("phase")) {
            phase = (String)params.get("phase");
        }
    }

    public TimeConfig makeConfig() {
        return new PhaseAlignedTimeConfig(phase);
    }

    public boolean needsEventInformation() {
        return true;
    }

    String phase = "ttp";
}