package edu.sc.seis.gee.task;

import java.util.Map;
import java.util.StringTokenizer;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;

/**
 * PhasePlotTask.java
 *
 *
 * Created: Mon Jul  8 13:33:52 2002
 *
 * @author <a href="mailto:">Charlie Groves</a>
 * @version
 */

public class PhasePlotTask implements Task{
    public void configure(Map params) throws ConfigurationException {
        this.params = params;
        CommonAccess ca = CommonAccess.getCommonAccess();
        if (params.containsKey("travelCalculator")){
            String tc = (String)params.get("travelCalculator");
            calculator = (TauPTask)ca.getTaskAction(tc).getTask();
            calculator.setTauPListener(this);
        }else {
            throw new ConfigurationException("No travelCalculator in PhasePlotTask configuration!");
        } // end of else

        if(params.containsKey("phaseDestinations")) {
            String pd = (String)params.get("phaseDestinations");
            StringTokenizer destinationTokenizer = new StringTokenizer(pd,",");
            int tokens = destinationTokenizer.countTokens();
            destinations = new ColumnSeismogramTask[tokens];
            for (int i = 0; i < tokens; i++){
                String destID = destinationTokenizer.nextToken();
                destinations[i]  = (ColumnSeismogramTask)ca.getTaskAction(destID).getTask();
            }
        }else{
            throw new ConfigurationException("no phaseDestinations in PhasePlotTask configuration");
        }
    }

    public void invoke() {
        if(displayed){
            for (int i = 0; i < destinations.length; i++){
                destinations[i].removeTravelTimes();
            }
        }else{
            for (int i = 0; i < destinations.length; i++){
                destinations[i].displayTravelTimes();
            }
        }
        displayed = !displayed;
    }
    
    public boolean getDisplayed(){ return displayed; }

    public void update(){
        if(displayed){
            for (int i = 0; i < destinations.length; i++){
                destinations[i].removeTravelTimes();
                destinations[i].displayTravelTimes();
            }
        }
    }

    public void destroy(){}

    protected boolean displayed = false;

    protected TauPTask calculator;

    protected ColumnSeismogramTask[] destinations;

    protected Map params;
}// PhasePlotTask
