/**
 * PhaseFilter.java
 *
 * @author Created by Omnicore CodeGuide
 */

package edu.sc.seis.gee.task;
import java.util.List;
import java.util.Map;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.fissuresUtil.display.PhasePhilter;
import edu.sc.seis.gee.configurator.ConfigurationException;



public class PhaseFilter implements Task {


    /**
     * Configures a <code>Task</code> with any needed parameters. The Task
     * should have default values for as many things as possible, but can
     * throw a ConfigureException if a required parameter is missing.
     *
     * @param params a <code>Map</code> value
     * @exception ConfigurationException if an error occurs
     */
    public void configure(Map params) throws ConfigurationException {
         offset = new TimeInterval(Double.parseDouble((String)params.get("offset")), UnitImpl.SECOND);
    }

    /**
     * Called when reset is invoked on gee or if this task is no longer being used
     *
     */
    public void destroy() {
        // TODO
    }

    /**
     * Called when a task is to be executed, usually by a menu or toolbar
     * selection for simple tasks.
     *
     *
     * @exception Exception if an error occurs
     */
    public void invoke() throws Exception {
        // TODO
    }

    public List<Arrival> filter(List<Arrival> arrivals) {
        return PhasePhilter.filter(arrivals, offset);
    }
    
    TimeInterval offset = new TimeInterval(10 , UnitImpl.SECOND);
}

