package edu.sc.seis.gee.task;

import java.awt.BorderLayout;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import edu.sc.seis.gee.parmo3d.PartMo;
import edu.sc.seis.gee.configurator.ConfigurationException;

public class ParticleMotion3DTask extends JPanel implements Task{
    
    public void invoke() throws ConfigurationException {
        if(!guiInitialized) {
            guiInitialized = true;
            createGUI();
        }
    }
    
    public void destroy(){}
    
    public void createGUI() throws ConfigurationException {
        this.setLayout(new BorderLayout());
        try {
            // check for no java3d, ie on Mac
            Class.forName("javax.media.j3d.Group");
        } catch (ClassNotFoundException e) {
            // no java3d
            String message = "Sorry Java3D is not available on this computer and so this task will not work.";
            if (configParams.containsKey("unsupportedOS_"+System.getProperty("os.name"))) {
                message = ((String)configParams.get("unsupportedOS_"+System.getProperty("os.name")));
            }
            JOptionPane.showMessageDialog(null, message, "Java3D not available", JOptionPane.WARNING_MESSAGE);
            return;
        }
        
        float bazimuth = 0;
        float ang = 0;
        try {
            bazimuth = Float.parseFloat((String)configParams.get("backazimuth"));
            
        } catch(NumberFormatException nfe) {
            bazimuth = 0;
        }
        
        try {
            ang = Float.parseFloat((String)configParams.get("angle"));
        } catch(NumberFormatException nfe) {
            ang = 0;
        }
        PartMo particleMotion = new PartMo(bazimuth, ang);
        add(particleMotion, BorderLayout.CENTER);
    }
    
    public void configure(Map params) {
        this.configParams = params;
        try {
            // check for no java3d, ie on Mac
            Class.forName("javax.media.j3d.Group");
        } catch (ClassNotFoundException e) {
            // no java3d, do this so we do not display a frame
            params.put(DISPLAY_LOCATION, NONE);
            TaskAction ta = (TaskAction)params.get(TASK_ACTION);
            ta.setEnabled(false);
        }
    }
    
    private Map configParams;
    
    private boolean guiInitialized = false;
}

