package edu.sc.seis.gee.task;

import java.awt.Cursor;
import java.awt.Point;
import java.util.Map;
import com.bbn.openmap.event.MapMouseMode;
import com.bbn.openmap.event.SelectMouseMode;
import edu.sc.seis.fissuresUtil.map.OpenMap;
import edu.sc.seis.fissuresUtil.map.tools.OpenMapTool;
import edu.sc.seis.fissuresUtil.map.tools.PanTool;
import edu.sc.seis.fissuresUtil.map.tools.ZoomTool;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;

public class OpenMapToolTask implements Task {

    private Map configParams;

    private String toolType;

    private OpenMap openMap;

    private MapMouseMode omTool;

    private Cursor modeCursor, pressedCursor;

    public static final Point HOTPOINT_32X32 = new Point(16, 16);

    public static final Point HOTPOINT_24X24 = new Point(12, 12);

    public static final Point HOTPOINT_16X16 = new Point(8, 8);

    public OpenMapToolTask() {}

    /**
     * bo * Called when a task is to be executed, usually by a menu or toolbar
     * selection for simple tasks.
     * 
     * @exception Exception
     *                if an error occurs
     */
    public void invoke() throws Exception {
        if(toolType.equals("resetZoom")) {
            ((ZoomTool)omTool).reset();
        } else {
            openMap.setActiveMouseMode(omTool);
        }
    }

    /**
     * Called when reset is invoked on gee or if this task is no longer being
     * used
     */
    public void destroy() {
    // TODO
    }

    /**
     * Configures a <code>Task</code> with any needed parameters. The Task
     * should have default values for as many things as possible, but can throw
     * a ConfigureException if a required parameter is missing.
     * 
     * @param params
     *            a <code>Map</code> value
     * @exception ConfigurationException
     *                if an error occurs
     */
    public void configure(Map params) throws ConfigurationException {
        configParams = params;
        String openMapTaskId = (String)params.get("openmaptask");
        if((openMapTaskId == null) || (openMapTaskId.length() == 0)) { throw new ConfigurationException("OpenMap Task must be set in config file, "
                + "OpenMapTask id = '" + openMapTaskId + "'"); }
        TaskAction openMapTaskAction = CommonAccess.getCommonAccess()
                .getTaskAction(openMapTaskId);
        OpenMapTask openMapTask = (OpenMapTask)openMapTaskAction.getTask();
        openMap = openMapTask.getOpenMap();
        if(params.containsKey("toolType")) {
            toolType = (String)params.get("toolType");
        } else throw new ConfigurationException("no tool specified");
        float x = .5f;
        float y = .5f;
        if(params.containsKey("hotspot_offset_x")) {
            String xString = (String)params.get("hotspot_offset_x");
            x = Float.parseFloat(xString);
        }
        if(params.containsKey("hotspot_offset_y")) {
            String yString = (String)params.get("hotspot_offset_y");
            y = Float.parseFloat(yString);
        }
        if(params.containsKey("modeCursor")) {
            String imageFilePath = (String)params.get("modeCursor");
            imageFilePath = "edu/sc/seis/gee/data/images/" + imageFilePath;
            modeCursor = CursorUtil.getCursor(toolType, imageFilePath, x, y);
        } else {
            modeCursor = Cursor.getDefaultCursor();
        }
        if(params.containsKey("pressedCursor")) {
            String imageFilePath = (String)params.get("pressedCursor");
            imageFilePath = "edu/sc/seis/gee/data/images/" + imageFilePath;
            pressedCursor = CursorUtil.getCursor(toolType + "pressedCursor",
                                                 imageFilePath,
                                                 x,
                                                 y);
        } else {
            pressedCursor = Cursor.getDefaultCursor();
        }
        double zoomFactor = 1.0;
        if(toolType.startsWith("zoom")) {
            try {
                zoomFactor = Double.parseDouble((String)params.get("zoomFactor"));
            } catch(Exception e) {
                throw new ConfigurationException("no zoom factor set, or it is malformed",
                                                 e);
            }
            omTool = new ZoomTool(openMap, (float)zoomFactor, toolType);
            setCursors();
        } else if(toolType.equals("resetZoom")) {
            omTool = new ZoomTool(openMap, (float)zoomFactor, toolType);
        } else if(toolType.equals("pan")) {
            omTool = new PanTool(openMap);
            setCursors();
        } else if(toolType.equals("selection")) {
            omTool = new SelectMouseMode();
        } else throw new ConfigurationException(toolType + ": no such tool");
        openMap.addMouseMode(omTool);
        if(toolType.equals("selection")) {
            openMap.setActiveMouseMode(omTool);
        }
    }

    public MapMouseMode getTool() {
        return omTool;
    }

    private void setCursors() {
        OpenMapTool omt = (OpenMapTool)omTool;
        omt.setModeCursor(modeCursor);
        omt.setPressedCursor(pressedCursor);
    }
}