package edu.sc.seis.gee.task;

import java.awt.Cursor;
import java.util.Map;
import edu.sc.seis.fissuresUtil.display.BorderedDisplay;
import edu.sc.seis.fissuresUtil.display.drawable.Crosshair;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseEvent;
import edu.sc.seis.gee.configurator.ConfigurationException;

public class NullCrosshairTask extends MouseMovableTask{
	
	public NullCrosshairTask(){
		setMovable(crosshair);
		setCursor(Cursor.getPredefinedCursor(Cursor.CROSSHAIR_CURSOR));
	}
	
    public void configure(Map params) throws ConfigurationException {}

    public void mouseEntered(SDMouseEvent e){
		super.mouseEntered(e);
        if(e.getDisplay().isFilled(BorderedDisplay.TOP_CENTER)){
            crosshair.setTopTriangleVisible(true);
        }else crosshair.setTopTriangleVisible(false);
        if(e.getDisplay().isFilled(BorderedDisplay.BOTTOM_CENTER)){
            crosshair.setBottomTriangleVisible(true);
        }else crosshair.setBottomTriangleVisible(false);
    }

    private Crosshair crosshair = new Crosshair(0,0);
}
