package edu.sc.seis.gee.task;

import java.awt.BorderLayout;
import java.util.Map;
import javax.swing.JPanel;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.FrameManager;
import edu.sc.seis.gee.configurator.ConfigurationException;

/**
 * NewPanel.java
 *
 *
 * Created: Tue Apr  8 14:16:56 2003
 *
 * @author <a href="mailto:crotwell@owl.seis.sc.edu">Philip Crotwell</a>
 * @version 1.0
 */
public class NewMainTab implements Task {
    public void configure(Map params) throws ConfigurationException {
        if(params.containsKey("PlaceholderImage")){
            CommonAccess ca = CommonAccess.getCommonAccess();
            String placeholderID = (String)params.get("PlaceholderImage");
            placeholderTA = ca.getTaskAction(placeholderID);
        }
        name = (String)params.get(TASK_NAME);
    }

    public void destroy() {

    }

    public void invoke() throws Exception {
        JPanel panel = FrameManager.getManager().createNewTab(FrameManager.getManager().getCurrentMainFrame(),
                                                              name);
        if(placeholderTA != null){
            panel.setLayout(new BorderLayout());
            PlaceholderImage image = (PlaceholderImage)placeholderTA.getTask();
            panel.add(image.generateImagePanel());
        }
    }

    private String name;
    private TaskAction placeholderTA;

} // NewMainTab
