package edu.sc.seis.gee.task;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.xml.parsers.ParserConfigurationException;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.fissuresUtil.display.RecordSectionDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.drawable.Flag;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseEvent;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.StdAuxillaryDataNames;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.FrameManager;
import edu.sc.seis.gee.configurator.ConfigurationException;

public class MarkerFlagTask extends VerticalLineTask {
	private FlagNamingDialog namingDialog = new FlagNamingDialog();
	
	public MarkerFlagTask(){
		super();
		line.setColor(Color.YELLOW);
	}

	public void configure(Map params) throws ConfigurationException {
		String taskId = (String) params.get("colSeisTask");
		if ((taskId == null || taskId.length() == 0)) {
			throw new ConfigurationException(
					"colSeisTask must be set in configuration file");
		}
		TaskAction taskAction = CommonAccess.getCommonAccess().getTaskAction(
				taskId);
		colSeis = (ColumnSeismogramTask) taskAction.getTask();
	}

	public void invoke() {
		if (colSeis.getDisplay() instanceof RecordSectionDisplay) {
			JOptionPane.showMessageDialog(FrameManager.getManager()
					.getCurrentMainFrame(), "You cannot add Pick Flags in Record Section viewing mode.");
		} else {
			GlobalToolBar.setActive(this);
		}
	}

	public void destroy() {
	}

	public void mouseClicked(SDMouseEvent event) {
		namingDialog.openDialog(event);
	}

	public String getDefaultName(SeismogramDisplay disp, String name) {
		int i = 0;
		String tagName = name;
		Iterator it = disp.iterator(Flag.class);
		while (it.hasNext()) {
			Flag cur = (Flag) it.next();
			if (cur.getName().equals(name)) {
				i++;
			}
		}
		return name + "_" + i;
	}

	public void createFlag(SeismogramDisplay disp, MicroSecondDate time,
			String name) {
		Flag flag = new Flag(time, name);
		flag.setColor(Color.YELLOW);
		disp.add(flag);
		String auxDataString = StdAuxillaryDataNames.PICK_FLAG + '_'
				+ getDefaultName(disp, name);
		try {
			disp.getSeismograms()[0].addAuxillaryData(auxDataString, Flag
					.createFlagElement(name, time));
		} catch (ParserConfigurationException e) {
			GlobalExceptionHandler.handle(
					"There was a problem putting your flag in the seismogram.",
					e);
		}
	}

	private class FlagNamingDialog extends JFrame {

		private JPanel textPanel = new JPanel();

		private JPanel buttonPanel = new JPanel();

		private JTextField nameField = new JTextField("", 8);

		private JButton okButton = new JButton("OK");

		private JButton cancelButton = new JButton("Cancel");

		private SeismogramDisplay currentDisplay = null;

		private MicroSecondDate currentTime = null;

		public FlagNamingDialog() {
			super("Name Flag");
			nameField.addKeyListener(new KeyListener() {

				public void keyTyped(KeyEvent e) {
					if (e.getKeyCode() == KeyEvent.VK_ENTER) {
						doCreateAction();
					} else if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
						hide();
					}
				}

				public void keyPressed(KeyEvent e) {
					if (e.getKeyCode() == KeyEvent.VK_ENTER) {
						doCreateAction();
					} else if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
						hide();
					}
				}

				public void keyReleased(KeyEvent e) {
				}

			});
			okButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent p1) {
					doCreateAction();
				}
			});
			okButton.setSelected(true);
			cancelButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent p1) {
					hide();
				}
			});
			textPanel.setLayout(new BorderLayout());
			textPanel.add(new JLabel("Flag Name: "), BorderLayout.WEST);
			textPanel.add(nameField, BorderLayout.EAST);
			buttonPanel.setLayout(new BorderLayout());
			buttonPanel.add(okButton, BorderLayout.WEST);
			buttonPanel.add(cancelButton, BorderLayout.EAST);
			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(textPanel, BorderLayout.NORTH);
			getContentPane().add(buttonPanel, BorderLayout.SOUTH);
			//setSize(new Dimension(200, 100));
			pack();
		}

		public void doCreateAction() {
			createFlag(currentDisplay, currentTime, nameField.getText());
			hide();
		}

		public void openDialog(SDMouseEvent event) {
			this.setLocationRelativeTo(FrameManager.getManager()
					.getCurrentMainFrame());
			currentDisplay = event.getDisplay();
			currentTime = event.getTime();
			nameField.setText("P");
			show();
		}

	}

	private ColumnSeismogramTask colSeis;
}

