package edu.sc.seis.gee.task;

import java.util.Map;
import javax.swing.JOptionPane;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.fissuresUtil.chooser.ChannelChooser;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;

/**
 * MapToDisplayTask.java
 * 
 * @author Created by Philip Oliver-Paull
 */
public class MapToDisplayTask implements Task {

    private TaskAction colSeisTaskAction;

    private ShowEventsTask showEvents;

    private EventSeismogramTask eventSeisTask;

    private DisplayAllTask autoDisplay;

    private TaskAction chanChooserAction;

    /**
     * Configures a <code>Task</code> with any needed parameters. The Task
     * should have default values for as many things as possible, but can throw
     * a ConfigureException if a required parameter is missing.
     * 
     * @param params
     *            a <code>Map</code> value
     * @exception ConfigurationException
     *                if an error occurs
     */
    public void configure(Map params) throws ConfigurationException {
        String taskId;
        CommonAccess commonAccess = CommonAccess.getCommonAccess();
        TaskAction taskAction;
        taskId = (String)params.get("autoDisplayTask");
        taskAction = commonAccess.getTaskAction(taskId);
        autoDisplay = (DisplayAllTask)taskAction.getTask();
        taskId = (String)params.get("showEvents");
        taskAction = commonAccess.getTaskAction(taskId);
        showEvents = (ShowEventsTask)taskAction.getTask();
        taskId = (String)params.get("timeForEarthquake");
        taskAction = commonAccess.getTaskAction(taskId);
        eventSeisTask = (EventSeismogramTask)taskAction.getTask();
        taskId = (String)params.get("chanChooser");
        chanChooserAction = commonAccess.getTaskAction(taskId);
        if(params.containsKey("dispEnclosingTask")) {
            taskId = (String)params.get("dispEnclosingTask");
            colSeisTaskAction = commonAccess.getTaskAction(taskId);
        }
    }

    /**
     * Called when a task is to be executed, usually by a menu or toolbar
     * selection for simple tasks.
     * 
     * 
     * @exception Exception
     *                if an error occurs
     */
    public void invoke() throws Exception {
        EventAccessOperations[] event = showEvents.getSelectedEvents();
        if(event.length == 0) {
            JOptionPane.showMessageDialog(null,
                                          "You must select at least one event(circle) from the map before trying to load seismograms",
                                          "No Event Selected",
                                          JOptionPane.WARNING_MESSAGE);
        } else {
            MicroSecondDate oTime = new MicroSecondDate(event[0].get_preferred_origin().getOriginTime());
            ChannelChooser chanChooser = ((ChannelChooserTask)chanChooserAction.getTask()).getChannelChooser();
            if(chanChooser.getSelectedChannels(oTime).length != 0) {
                colSeisTaskAction.checkDisplayLocation(true);
                eventSeisTask.loadSeismograms(event,
                                              "First P-wave",
                                              -2.0,
                                              "First S-wave",
                                              10.0,
                                              autoDisplay);
            } else {
                if (chanChooser.getSelectedStations(oTime).length != 0) {
                    JOptionPane.showMessageDialog(null,
                                                  "The stations you selected do not have any channels that match your selection at the time of the event so GEE cannot load seismograms.",
                                                  "No Matching Channels",
                                                  JOptionPane.WARNING_MESSAGE);
                } else {
                JOptionPane.showMessageDialog(null,
                                              "You must select at least one seismograph station (blue triangles) from the map before trying to load seismograms.",
                                              "No Stations Selected",
                                              JOptionPane.WARNING_MESSAGE);
                }
            }
        }
    }

    /**
     * Called when reset is invoked on gee or if this task is no longer being
     * used
     * 
     */
    public void destroy() {}
}
