/**
 * MapLegendTask.java
 * 
 * @author Created by Omnicore CodeGuide
 */
package edu.sc.seis.gee.task;

import java.awt.BorderLayout;
import java.net.URL;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import edu.sc.seis.gee.configurator.ConfigurationException;

public class MapLegendTask implements Task {

    private JPanel legend = new LegendPanel();

    /**
     * Configures a <code>Task</code> with any needed parameters. The Task
     * should have default values for as many things as possible, but can throw
     * a ConfigureException if a required parameter is missing.
     * 
     * @param params
     *            a <code>Map</code> value
     * @exception ConfigurationException
     *                if an error occurs
     */
    public void configure(Map params) throws ConfigurationException {
        legend.setVisible(false);
    }

    /**
     * Called when a task is to be executed, usually by a menu or toolbar
     * selection for simple tasks.
     * 
     * 
     * @exception Exception
     *                if an error occurs
     */
    public void invoke() throws Exception {
        if(legend.isVisible()) {
            legend.setVisible(false);
        } else {
            legend.setVisible(true);
        }
    }

    /**
     * Called when reset is invoked on gee or if this task is no longer being
     * used
     * 
     */
    public void destroy() {}

    protected JPanel getLegend() {
        return legend;
    }
}

class LegendPanel extends JPanel {

    public LegendPanel() {
        setLayout(new BorderLayout());
        String imgPath = "edu/sc/seis/gee/data/images/";
        URL imgURL = getClass().getClassLoader().getResource(imgPath
                + "map_key_help.png");
        ImageIcon imageIcon = new ImageIcon(imgURL);
        JLabel imgLabel = new JLabel(imageIcon);
        add(imgLabel, BorderLayout.CENTER);
    }
}
