package edu.sc.seis.gee.task;

import java.util.Map;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.registrar.RMeanAmpConfig;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;



public class GlobalizeAmpTask implements AmpSetterTask{
    public void configure(Map params) throws ConfigurationException {
        String colSeisId = (String)params.get("colSeisTarget");
        TaskAction ta = CommonAccess.getCommonAccess().getTaskAction(colSeisId);
        colSeis = (ColumnSeismogramTask)ta.getTask();
    }

    public void invoke() throws Exception {
        colSeis.setAmpSetter(this);
    }

    public void setAmp(SeismogramDisplay disp){
        disp.setGlobalizedAmpConfig(new RMeanAmpConfig());
        //makes change apparent on mac and linux, not sure why this is needed
        if(disp.getTimeConfig() != null){
            disp.getTimeConfig().shaleTime(0,1);
        }
    }

    public void destroy() {}

    private ColumnSeismogramTask colSeis;
}

