package edu.sc.seis.gee.task;


import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Map;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.gee.CommonAccess;


/**
 * FindDataSetsTask.java
 *
 *
 * Created: Tue Jan 22 12:09:58 2002
 *
 * @author <a href="mailto:">Srinivasa Telukutla</a>
 * @version
 */

public class FindDataSetsTask implements Task{
    public FindDataSetsTask (String path){

        this.path = path;
        try {

            pw = new PrintWriter(new BufferedWriter(new FileWriter("/home/telukutl/gee/datasetsxml.xml")));

        } catch(java.io.FileNotFoundException fnfe) {
            GlobalExceptionHandler.handle(fnfe);
            //throw new java.io.FileNotFoundException();

        }  catch(java.io.IOException ioe) {

            GlobalExceptionHandler.handle("Exception caught while writing to the file", ioe);
        }

    }

    public void invoke() {

        pw.println("<?xml version=\"1.0\">");
        generateXMLFile(path);
        pw.println("</xml>");
        pw.close();

    }

    public void destroy(){}

    public void configure(java.util.Map params) {


        configParams = params;
        String respondId = (String)params.get("respondId");
        TaskAction respondAction =
            CommonAccess.getCommonAccess().getTaskAction(respondId);
        //loadDataSetTask = (LoadDataSetTask)respondAction.getTask();

    }

    public  void generateXMLFile(String path) {

        File file = new File(path);
        if( file.isDirectory()) {
            File[] files = file.listFiles();
            for(int counter = 0; counter < files.length; counter++) {

                //      if(files[0].isDirectory())
                generateXMLFile(files[counter].getAbsolutePath());


            }


        } else {

            String fileName = file.getName();
            String tempFileName =  fileName.substring(fileName.length() - 3, fileName.length());

            if(tempFileName.equals(".ds")) {
                //      try
                {
                    //DataSet dataSet = loadDataSetTask.getDataSet(file.toURL());
                    pw.println("<dataset>");
                    pw.println("\t<name>"+fileName+"</name>");
                    // pw.println("\t<id>"+localDataSet.id()+"</id>");
                    pw.println("\t<datasetURL>"+path+"</datasetURL>");
                    pw.println("</dataset>");
                }

            }

        }

    }

    private String path;

    private java.io.PrintWriter pw;

    private Map configParams;

    private LoadDataSetTask loadDataSetTask = new LoadDataSetTask();

    //private java.io.OutputStream os;
}// FindDataSetsTask
