package edu.sc.seis.gee.task;

import java.util.Map;
import java.util.StringTokenizer;
import edu.sc.seis.fissuresUtil.freq.NamedFilter;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;

/**
 * FilterTask.java
 *
 *
 * Created: Thu Jul 11 14:37:47 2002
 *
 * @author <a href="mailto:">Charlie Groves</a>
 * @version
 */

public class FilterTask implements Task{
    public void configure(Map params) throws ConfigurationException{
        this.params = params;
        if(params.containsKey("filterTargets")){
            String destinationId = (String)params.get("filterTargets");
            destinations = parseFilterTargets(destinationId);
        }else {
            throw new ConfigurationException("filter task requires a colSeisDisplay in the configuration");
        }
        if(params.containsKey("lowFreqCorner")){
            lowFreqCorner = Double.parseDouble((String)params.get("lowFreqCorner"));
        }
        if(params.containsKey("highFreqCorner")){
            highFreqCorner = Double.parseDouble((String)params.get("highFreqCorner"));
        }
        if(params.containsKey("numPoles")){
            numPoles = Integer.parseInt((String)params.get("numPoles"));
        }if(params.containsKey("filterType") && ((String)params.get("filterType")).equalsIgnoreCase("two pass")){
            filterType = NamedFilter.TWOPASS;
        }
        filter = new NamedFilter(lowFreqCorner, highFreqCorner, numPoles, filterType,
                                     (String)params.get(TASK_NAME));
        numFilters++;
    }
    
    public static FilterTarget[] parseFilterTargets(String destinationId) throws ConfigurationException {
        CommonAccess ca = CommonAccess.getCommonAccess();
        StringTokenizer destinationTokenizer = new StringTokenizer(destinationId,",");
        int tokens = destinationTokenizer.countTokens();
        FilterTarget[] destinations = new FilterTarget[tokens];
        for (int i = 0; i < tokens; i++){
            String destID = destinationTokenizer.nextToken();
            destinations[i]  = (FilterTarget)ca.getTaskAction(destID).getTask();
        }
        return destinations;
    }

    public void destroy(){}

    public void invoke(){
        filter.toggleVisibility();
        for (int i = 0; i < destinations.length; i++){
            destinations[i].applyFilter(filter, filter.getVisibility());
        }
    }

    protected static int numFilters = 0;

    protected NamedFilter filter;

    protected FilterTarget[] destinations;

    protected Map params;

    //default values for filtering
    protected double lowFreqCorner = 0.0;

    protected double highFreqCorner = 0.05;

    protected int numPoles = 2;

    protected int filterType = 0;

}// FilterTask
