package edu.sc.seis.gee.task;

import java.util.ArrayList;
import java.util.List;

import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.chooser.ChannelChooserException;
import edu.sc.seis.fissuresUtil.chooser.ChannelChooserSource;
import edu.sc.seis.fissuresUtil.chooser.CoarseAvailableData;
import edu.sc.seis.fissuresUtil.sac.InvalidResponse;
import edu.sc.seis.sod.source.SodSourceException;
import edu.sc.seis.sod.source.network.FdsnStation;


public class FDSNChannelChooserSource implements ChannelChooserSource {
    
    FdsnStation fdsnStation;
    
    public FDSNChannelChooserSource(FdsnStation fdsnStation) {
        this.fdsnStation = fdsnStation;
    }

    @Override
    public List<NetworkAttrImpl> getNetworks() throws ChannelChooserException {
        try {
            List<NetworkAttrImpl> out = new ArrayList<NetworkAttrImpl>();
            out.addAll(fdsnStation.getNetworks());
            return out;
        } catch(SodSourceException e) {
            throw new ChannelChooserException(e);
        }
    }

    @Override
    public List<StationImpl> getStations(NetworkAttrImpl net) throws ChannelChooserException {
        try {
            List<StationImpl> out = new ArrayList<StationImpl>();
            out.addAll(fdsnStation.getStations(net));
            return out;
        } catch(SodSourceException e) {
            throw new ChannelChooserException(e);
        }
    }

    @Override
    public List<ChannelImpl> getChannels(StationImpl station) throws ChannelChooserException {
        try {
            List<ChannelImpl> out = new ArrayList<ChannelImpl>();
            out.addAll(fdsnStation.getChannels(station));
            return out;
        } catch(SodSourceException e) {
            throw new ChannelChooserException(e);
        }
    }

    @Override
    public QuantityImpl getSensitivity(ChannelImpl chan) throws ChannelNotFound, InvalidResponse,
            ChannelChooserException {
        try {
            return fdsnStation.getSensitivity(chan);
        } catch(SodSourceException e) {
            throw new ChannelChooserException(e);
        }
    }

    @Override
    public Instrumentation getInstrumentation(ChannelImpl chan) throws ChannelNotFound, InvalidResponse,
            ChannelChooserException {
        try {
            return fdsnStation.getInstrumentation(chan);
        } catch(SodSourceException e) {
            throw new ChannelChooserException(e);
        }
    }
    
    public FdsnStation getFdsnStation() {
        return fdsnStation;
    }

    public String toString() {
        return fdsnStation.getName();
    }
}
