package edu.sc.seis.gee.task;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Category;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.StationIdUtil;
import edu.sc.seis.fissuresUtil.display.EventInfoDisplay;
import edu.sc.seis.fissuresUtil.display.RecordSectionDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.VerticalSeismogramDisplay;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;

/**
 * EventInfoTask.java
 *
 *
 * Created: Mon Jun  3 11:13:53 2002
 *
 * @author <a href="mailto:">Philip Crotwell</a>
 * @version $Id: EventInfoTask.java 19826 2008-06-17 14:48:33Z crotwell $
 */

public class EventInfoTask
    implements GUITask {

    public EventInfoTask (){
    }

    public void configure(Map params) throws ConfigurationException {
        configParams = params;
        display = new EventInfoDisplay();
        if(params.containsKey("colSeisDisplay")){
            String colSeisId = (String)params.get("colSeisDisplay");
            colSeis =
                ((ColumnSeismogramTask)CommonAccess.getCommonAccess().getTaskAction(colSeisId).getTask());
        }
    }

    public JComponent getGUI() throws ConfigurationException {
        return display;
    }

    /** True if this GUI has a "more options" funtionality. More options
     *  appear in a separate panel below the main gui, and can be shown/hidden
     *  with a "Show More Options" and "Hide More Options" button that is
     *  provided automatically is this return true.
     */
    public boolean hasMoreOptions() {
        return false;
    }

    /** Gets the "More Options" GUI component.
     */
    public JComponent getMoreOptionsGUI() {
        return null;
    }

    public void invoke() throws ConfigurationException {
        if (colSeis != null) {
            Map stations;
            Map events = new HashMap();
            List displays = new LinkedList();
            if(colSeis.getDisplay() instanceof VerticalSeismogramDisplay){
                displays = ((VerticalSeismogramDisplay)colSeis.getDisplay()).getDisplays();
            }
            else if (colSeis.getDisplay() instanceof RecordSectionDisplay){
                displays.add(colSeis.getDisplay());
            }
            Iterator it = displays.iterator();
            while (it.hasNext()) {
                SeismogramDisplay currDisp =
                    ((SeismogramDisplay)it.next());
                DataSetSeismogram[] seismos = currDisp.getSeismograms();
                for(int i = 0; i < seismos.length; i++){
                    DataSet dataset = seismos[i].getDataSet();
                    EventAccessOperations currEvent = dataset.getEvent();

                    if ( ! events.containsKey(currEvent)) {
                        events.put(currEvent, new HashMap());
                    } // end of if ( ! events.containsKey(currEvent))

                    // use HashMap so we can key off of the station id and
                    // avoid duplicates if the station objects are equivalent,
                    // but not the same object
                    stations = (HashMap)events.get(currEvent);
                    try {
                        Channel chan =
                            dataset.getChannel(seismos[i].getRequestFilter().channel_id);
                        // check for channel not in dataset
                        if ( chan != null) {
                            Station currStation = chan.getSite().getStation();
                            stations.put(StationIdUtil.toString(currStation.get_id()),
                                         currStation);

                        } else {

                        } // end of else

                    } catch (Throwable e) {
                        GlobalExceptionHandler.handle("Problem getting the station information for channel "+
                                                         ChannelIdUtil.toString(seismos[i].getRequestFilter().channel_id),
                                                     e);
                    } // end of try-catch

                }
            }


            display.clear();
            it = events.keySet().iterator();
            if (it.hasNext()){
                while (it.hasNext()) {
                    EventAccessOperations currEvent = (EventAccessOperations)it.next();
                    stations = (HashMap)events.get(currEvent);
                    Collection stationCollection = stations.values();
                    Station[] stationArray =
                        (Station[])stationCollection.toArray(new Station[0]);
                    display.appendEventStation(currEvent, stationArray);
                } // end of while (it.hasNext())
            }
            else{
                display.appendEvent(null);
            }
        }
    }

    public void destroy(){}

    protected Map configParams;

    protected EventInfoDisplay display = null;

    protected ColumnSeismogramTask colSeis = null;

    static Category logger =
        Category.getInstance(EventInfoTask.class.getName());

}// EventInfoTask

