package edu.sc.seis.gee.task;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseAdapter;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseEvent;
import edu.sc.seis.gee.configurator.ConfigurationException;

public class DragTask extends SDMouseAdapter implements Task {

    public void configure(java.util.Map params) throws ConfigurationException {
        if(params.containsKey("defaultcursor")) {
            String imagePath = (String)params.get("defaultcursor");
            imagePath = BASE_PATH + imagePath;
            handOpen = CursorUtil.getCursor("HandOpen", imagePath, .5f, .5f);
        } else throw new ConfigurationException("defaultcursor not set");
        if(params.containsKey("dragcursor")) {
            String imagePath = (String)params.get("dragcursor");
            imagePath = BASE_PATH + imagePath;
            handClosed = CursorUtil.getCursor("ClosedHand", imagePath, .5f, .5f);
        } else throw new ConfigurationException("dragcursor not set");
    }

    public void invoke() {
        GlobalToolBar.setActive(this);
    }

    public void destroy() {}

    public void mouseDragged(SDMouseEvent me) {
        if(previousEvent != null) {
            double width = me.getComponent().getSize().width;
            double xDiff = -((me.getX() - previousEvent.getX()) / width);
            me.getDisplay().getTimeConfig().shaleTime(xDiff, 1);
        }
        previousEvent = me;
    }

    public void mousePressed(SDMouseEvent me) {
        isPressed = true;
        previousEvent = me;
        setCursor(handClosed, me);
    }

    public void mouseReleased(SDMouseEvent me) {
        isPressed = false;
        previousEvent = null;
        setCursor(handOpen, me);
    }

    public void mouseEntered(SDMouseEvent me) {
        setCursor(handOpen, me);
    }

    public void mouseExited(SDMouseEvent me) {
        if(!isPressed) setCursor(Cursor.getDefaultCursor(), me);
    }

    private void setCursor(Cursor cursor, MouseEvent me) {
        me.getComponent().setCursor(cursor);
    }

    private Cursor handOpen, handClosed;

    private MouseEvent previousEvent;

    private boolean isPressed = false;

    private static final String BASE_PATH = "edu/sc/seis/gee/data/images/";
}//DragTask
