package edu.sc.seis.gee.task;

import java.util.Map;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.dataSetBrowser.DataSetBrowser;

/**
 * AutoDisplayTask.java
 *
 *
 * Created: Wed Feb 20 09:38:09 2002
 *
 * @author <a href="mailto:crotwell@pooh">Philip Crotwell</a>
 * @version
 */

public class DisplayAllTask extends DataSetCrawler implements Task {
    public void configure(Map params) throws ConfigurationException {
        this.params = params;
        if (params.containsKey("seisDisplay")) {
            String displayId = (String)params.get("seisDisplay");
            dispAction =CommonAccess.getCommonAccess().getTaskAction(displayId);
            display = (ColumnSeismogramTask)dispAction.getTask();
        } else {
            throw new ConfigurationException("seisDisplay parameter must defined");
        } // end of else
        
        if(params.containsKey("bringToFront")){
            bringToFront = Boolean.getBoolean((String)params.get("bringToFront"));
        }
        
        
        if(params.containsKey("DataSetBrowser")) {
            String displayId = (String)params.get("DataSetBrowser");
            dsbAction =
                CommonAccess.getCommonAccess().getTaskAction(displayId);
            dataSetBrowser = (DataSetBrowser)dsbAction.getTask();
			initCrawler(dsbAction);
        }else{
            throw new ConfigurationException("AutoDisplayTask must have a DataSetBrowser associated with it");
        }
        if(params.containsKey(ORIENTATION)){
            String ft = (String)params.get(ORIENTATION);
            if(ft.equals(NORTH)){
                filter = new NFilter();
            }else if(ft.equals(VERTICAL)){
                filter = new ZFilter();
            }else if(ft.equals(EAST)){
                filter = new EFilter();
            }else if(ft.equals(HORIZONTAL)){
                OrientationFilter[] filters = { new NFilter(), new EFilter() };
                filter = new ComboFilter(filters);
            }else{
                throw new ConfigurationException("The orientation " + ft + " does not match any existing filters.  Use one of the orientation names in DefaultParamNames");
            }
        }else{
            filter = new NoFilter();
        }
        
    }
    
    public void invoke() throws Exception {
        boolean displayedSomething = crawlDataSets();
        if(bringToFront && displayedSomething){
            dispAction.checkDisplayLocation(true);
        }
    }

    public void destroy(){}

	public void crawlAction(DataSetSeismogram seis){
		display(seis);
	}
    
    public void display(DataSetSeismogram seis){
        if(filter.filter(seis)){
            display.addSeismogram(seis);
        }
    }
    
    public interface OrientationFilter{
        public boolean filter(DataSetSeismogram seis);
    }
    
    private class NoFilter implements OrientationFilter{
        public boolean filter(DataSetSeismogram seis){
            return true;
        }
    }
    
    private class ZFilter implements OrientationFilter{
        public boolean filter(DataSetSeismogram seis){
            if(DisplayUtils.getOrientationName(seis).equals("Up")){
                return true;
            }
            return false;
        }
    }
    
    private class EFilter implements OrientationFilter{
        public boolean filter(DataSetSeismogram seis){
            if(DisplayUtils.getOrientationName(seis).equals("East")){
                return true;
            }
            return false;
        }
    }
    
    private class NFilter implements OrientationFilter{
        public boolean filter(DataSetSeismogram seis){
            if(DisplayUtils.getOrientationName(seis).equals("North")){
                return true;
            }
            return false;
        }
    }
    
    private class ComboFilter implements OrientationFilter{
        private ComboFilter(OrientationFilter[] filters){
            this.filters = filters;
        }
        
        public boolean filter(DataSetSeismogram seis){
            for (int i = 0; i < filters.length; i++){
                if(filters[i].filter(seis)){
                    return true;
                }
            }
            return false;
        }
        
        private OrientationFilter[] filters;
    }
    
    protected OrientationFilter filter;
    
    ColumnSeismogramTask display;
    
    TaskAction dispAction;
    
    private DataSetBrowser dataSetBrowser;
    
    private TaskAction dsbAction;
    
    private boolean bringToFront = true;
    
    Map params;
}// AutoDisplayTask
