package edu.sc.seis.gee.task;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import edu.sc.seis.fissuresUtil.display.registrar.RTTimeRangeConfig;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.gee.NoNetworkException;
import edu.sc.seis.gee.configurator.ConfigurationException;

/**
 * DataSetRealTimePlayerTask.java
 *
 *
 * Created: Tue Feb 26 09:30:29 2002
 *
 * @author <a href="mailto:">Srinivasa Telukutla</a>
 * @version
 */

public class DataSetRealTimePlayerTask extends ColumnSeismogramTask{

    public void invoke() throws ConfigurationException, NoNetworkException {
        super.invoke();
        if(!guiLoaded){
            ClassLoader loader = getClass().getClassLoader();
            TaskAction taskAction = (TaskAction)params.get(TASK_ACTION);

            ImageIcon[] rewIcons  = {new ImageIcon(loader.getResource("edu/sc/seis/gee/data/images/rew.png")),
                    new ImageIcon(loader.getResource("edu/sc/seis/gee/data/images/rew-lit.png"))};
            JButton rewindButton = new JButton(rewIcons[0]);
            rewindButton.setToolTipText("Click here to make the seismograms move quickly to the right");
            taskAction.addToToolBar(rewindButton);
            rewindButton.addActionListener(new RTSpeedChanger(-20, rewIcons, rewindButton));

            ImageIcon[] stopIcons  = {new ImageIcon(loader.getResource("edu/sc/seis/gee/data/images/stop.png")),
                    new ImageIcon(loader.getResource("edu/sc/seis/gee/data/images/stop-lit.png"))};
            stopButton = new JButton(stopIcons[1]);
            stopButton.setToolTipText("Click here to make the seismograms stop moving");
            currentButton = stopButton;
            currentButtonIcons = stopIcons;
            taskAction.addToToolBar(stopButton);
            stopButton.addActionListener(new RTSpeedChanger(0, stopIcons, stopButton));

            ImageIcon[] playIcons = {new ImageIcon(loader.getResource("edu/sc/seis/gee/data/images/play.png")),
                    new ImageIcon(loader.getResource("edu/sc/seis/gee/data/images/play-lit.png"))};
            playButton = new JButton(playIcons[0]);
            playButton.setToolTipText("Click here to make the seismograms move to the left");
            taskAction.addToToolBar(playButton);
            playButton.addActionListener(new RTSpeedChanger(1, playIcons, playButton));

            ImageIcon[] ffIcons  = {new ImageIcon(loader.getResource("edu/sc/seis/gee/data/images/fastf.png")),
                    new ImageIcon(loader.getResource("edu/sc/seis/gee/data/images/fastf-lit.png"))};
            JButton fastForwardButton = new JButton(ffIcons[0]);
            fastForwardButton.setToolTipText("Click here to make the seismograms move quickly to the left");
            taskAction.addToToolBar(fastForwardButton);
            fastForwardButton.addActionListener(new RTSpeedChanger(20, ffIcons, fastForwardButton));
            guiLoaded = true;
        }
    }

    private RTTimeRangeConfig getTimeConfig(){
        if(getDisplay().getTimeConfig() != null){
            if(!(getDisplay().getTimeConfig() instanceof RTTimeRangeConfig)){
                getDisplay().setTimeConfig(new RTTimeRangeConfig(getDisplay().getTimeConfig()));
            }
            if(getDisplay().getTimeConfig() != rtTimeRangeConfig){
                if(rtTimeRangeConfig != null){
                    rtTimeRangeConfig.stopTimer();
                }
                rtTimeRangeConfig = (RTTimeRangeConfig)getDisplay().getTimeConfig();
            }
        }
        return rtTimeRangeConfig;
    }

    private class RTSpeedChanger implements ActionListener{
        private RTSpeedChanger(int speed, ImageIcon[] icons, JButton button){
            this.speed = speed;
            this.icons = icons;
            this.button = button;
        }

        public void actionPerformed(ActionEvent e){
            if(currentButton == button){
                return;
            }
            if(getTimeConfig() != null){
                currentButton.setIcon(currentButtonIcons[0]);
                getTimeConfig().setSpeed(speed);
                if(speed != 0){
                    getTimeConfig().startTimer();
                }else{
                    getTimeConfig().stopTimer();
                }
                currentButton = button;
                currentButton.setIcon(icons[1]);
                currentButtonIcons = icons;
            }
        }

        private int speed;
        private ImageIcon[] icons;
        private JButton button;
    }

    public void destroy(){
        if(rtTimeRangeConfig != null){
            rtTimeRangeConfig.stopTimer();
        }
        super.destroy();
    }

    public void addSeismogram(DataSetSeismogram dss){
        if((getDisplay() == null ||
                getDisplay().getSeismograms().length == 0) &&
           rtTimeRangeConfig != null){
            rtTimeRangeConfig.stopTimer();
            rtTimeRangeConfig = null;
        }
        super.addSeismogram(dss);
    }

    protected void setDisplay(){
        super.setDisplay();
        getTimeConfig();
    }

    protected JButton stopButton, playButton;

    private JButton currentButton;

    private ImageIcon[] currentButtonIcons;

    private RTTimeRangeConfig rtTimeRangeConfig;

    private boolean guiLoaded = false;
}// DataSetRealTimePlayerTask
