/**
 * DataSetCrawler.java
 *
 * @author Created by Omnicore CodeGuide
 */

package edu.sc.seis.gee.task;

import javax.swing.JOptionPane;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.dataSetBrowser.DataSetBrowser;

public abstract class DataSetCrawler {

    private DataSetBrowser dataSetBrowser;
    private TaskAction dsbAction;
    private boolean promptIfNoOpenDatasets = true;

    /**
     * @param dsbAction must be a <code>TaskAction</code> of a <code>DataSetBrowser</code> task
     */
    public void initCrawler(TaskAction dsbAction) throws ConfigurationException{
        this.dsbAction = dsbAction;
        dataSetBrowser = (DataSetBrowser)dsbAction.getTask();
    }

    public boolean crawlDataSets(){
        boolean doneSomething = false;
        //here must get only the selected DataSet... but not the entire dataset.
        DataSet[] dataSets = dataSetBrowser.getSelectedDataSets();
        for(int counter = 0; counter < dataSets.length; counter++) {
            crawl(dataSets[counter]);
        }
        dataSets = dataSetBrowser.getOpenDataSets();
        for (int i = 0; i < dataSets.length; i++) {
            doneSomething = true;
            crawl(dataSets[i]);
        }
        if(!doneSomething){
            if(getDataSetsWithSeisCount(CommonAccess.getCommonAccess().getDataSetRoot()) == 1 || !promptIfNoOpenDatasets){
                crawl(CommonAccess.getCommonAccess().getDataSetRoot());
                doneSomething = true;
            }else{
                String message = "GEE doesn't know what data you want.  You can select the data you want in the data set editor and reload,\nselect everything in the data set editor, or cancel";
                String title = "More than one data set loaded";
                Object[] options = { "Select Everything", "Open DataSet Editor", "Cancel"};
                int choice = JOptionPane.showOptionDialog(null,
                                                          message,
                                                          title,
                                                          JOptionPane.YES_NO_CANCEL_OPTION,
                                                          JOptionPane.WARNING_MESSAGE,
                                                          null,
                                                          options,
                                                          options[0]);
                if(choice == JOptionPane.YES_OPTION){
                    crawl(CommonAccess.getCommonAccess().getDataSetRoot());
                    doneSomething = true;
                }else if(choice == JOptionPane.NO_OPTION){
                    dataSetBrowser.invoke();
                    try {
                        dsbAction.checkDisplayLocation();
                    } catch (ConfigurationException e) {
                        GlobalExceptionHandler.handle("something wrong with DataSetBrowser", e);
                    }
                }
            }
        }

        return doneSomething;
    }

    //returns the  number of data sets including the passed in one with
    //seismograms in them up to two sets.  If more than two data sets have
    //seismograms, it returns two at that point
    private int getDataSetsWithSeisCount(DataSet ds){
        int count = 0;
        if(ds.getDataSetSeismogramNames().length > 0){
            count++;
        }
        String[] dataSetNames = ds.getDataSetNames();
        for (int i = 0; i < dataSetNames.length && count < 2; i++) {
            count += getDataSetsWithSeisCount(ds.getDataSet(dataSetNames[i]));
        }
        return count;
    }

    public void crawl(DataSet dataset){
        if (dataset == null) {
            return;
        } // end of if (ds == null)

        String[] names = dataset.getDataSetSeismogramNames();
        for (int i = 0; i < names.length; i++){
            crawlAction(dataset.getDataSetSeismogram(names[i]));
        }
        names = dataset.getDataSetNames();
        for (int num=0; num<names.length; num++) {
            crawl(dataset.getDataSet(names[num]));
        } // end of for (int i=0; i<ds.datasets.length; i++)
    }
    
    public void setPromptIfNoOpenDataSets(boolean prompt){
        promptIfNoOpenDatasets = prompt;
    }

    public abstract void crawlAction(DataSetSeismogram seis);

}

