package edu.sc.seis.gee.task;

import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;

/**
 * ClearSelectionTask.java Created: Fri Jul 5 17:03:40 2002
 * 
 * @author <a href="mailto:groves@piglet">Charlie Groves </a>
 * @version
 */
public class ClearSelectionTask implements Task {

    public void configure(java.util.Map params) throws ConfigurationException {
        if(params.containsKey("selectionDisplay")) {
            String displayName = (String)params.get("selectionDisplay");
            selectionDisplayTaskAction = CommonAccess.getCommonAccess()
                    .getTaskAction(displayName);
        } else {
            throw new ConfigurationException("ClearSelectionTask requires knowledge of the display created by the selections in the config file");
        }
    }

    public void invoke() {
        if(selectionDisplayTaskAction.getJFrame() != null) {
            selectionDisplayTaskAction.getJFrame().dispose();
        }
    }

    public void destroy() {}

    private TaskAction selectionDisplayTaskAction;
}// ClearSelectionTask
