package edu.sc.seis.gee.task;

import java.util.Map;
import javax.swing.JOptionPane;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.dataSetBrowser.DataSetBrowser;

/**
 * ClearDataSetTask.java
 * 
 * 
 * Created: Wed Feb 27 09:24:49 2002
 * 
 * @author <a href="mailto:">Srinivasa Telukutla</a>
 * @version
 */
public class ClearDataSetTask implements Task {

    public void configure(Map configParams) throws ConfigurationException {
        this.params = configParams;
        dataSetBrowser = (DataSetBrowser)getTask("dataSetBrowser");
        columnSeismogramTask = (ColumnSeismogramTask)getTask("columnSeismogram");
        saveDataSetTask = (SaveDataSetTask)getTask("saveDataSet");
    }

    private Task getTask(String id) throws ConfigurationException {
        if(params.containsKey(id)) {
            return CommonAccess.getCommonAccess()
                    .getTaskAction((String)params.get(id))
                    .getTask();
        }
        return null;
    }

    public void invoke() throws ConfigurationException {
        if(saveDataSetTask != null) {
            int returnValue = JOptionPane.showConfirmDialog(null,
                                                            "Do you want to save the DataSet now",
                                                            "Save before clearing",
                                                            JOptionPane.YES_NO_CANCEL_OPTION,
                                                            JOptionPane.QUESTION_MESSAGE);
            if(returnValue == JOptionPane.CANCEL_OPTION) {
                return;
            } else if(returnValue == JOptionPane.YES_OPTION) {
                saveDataSetTask.invoke();
            }
        }
        CommonAccess.getCommonAccess().clearDataSetRoot();
        if(dataSetBrowser != null) {
            System.out.println("DSB NOT NULL");
            dataSetBrowser.refresh();
        }
        if(columnSeismogramTask != null) {
            columnSeismogramTask.removeAllDisplays();
        }
    }

    public void destroy() {}

    private DataSetBrowser dataSetBrowser;

    private ColumnSeismogramTask columnSeismogramTask;

    private SaveDataSetTask saveDataSetTask;

    private Map params;
}// ClearDataSetTask
