package edu.sc.seis.gee.task;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;

/**
 * CheckBoxDialog.java
 *
 *
 * Created: Fri Jun  7 14:25:10 2002
 *
 * @author <a href="mailto:">Srinivasa Telukutla</a>
 * @version
 */

public class CheckBoxDialog extends JFrame{
    public CheckBoxDialog (String[] values, String title){
        super(title);
        panel = new JPanel();
        toolPanel = new JPanel();
        textField = new JTextField(10);
        addButton = new JButton("Add");
        closeButton = new JButton("Close");
        jList = new JList(listModel);
        jList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        initGUI(values);
    }

    private void initGUI(String[] values) {

        toolPanel.setLayout(new FlowLayout());
        panel.setLayout(new BorderLayout());
        addButton.addActionListener(new ActionListener() {
                    public void actionPerformed(ActionEvent ae) {
                        addItem(textField.getText());
                        textField.setText("");
                    }

                });
        closeButton.addActionListener(new ActionListener() {
                    public void actionPerformed(ActionEvent ae) {
                        closeDialog();
                    }
                });

        toolPanel.add(new JLabel("Enter"));
        toolPanel.add(textField);
        toolPanel.add(addButton);
        toolPanel.add(closeButton);
        for(int counter = 0; counter < values.length; counter++) {
            addItem(values[counter]);
        }

        panel.add(new JLabel("Add Entry"), BorderLayout.NORTH);
        panel.add(toolPanel, BorderLayout.SOUTH);
        JScrollPane scrollPane = new JScrollPane(jList);
        panel.add(scrollPane, BorderLayout.CENTER);
        this.getContentPane().add(panel);
    }

    public String[] getValues() {
        DefaultListModel model = (DefaultListModel)jList.getModel();
        String[] out = new String[model.getSize()];
        model.copyInto(out);
        return out;
    }

    public void addItem(String value) {
        if(value == null || value.length() == 0) return;
        DefaultListModel model = (DefaultListModel)jList.getModel();
        if(model.indexOf(value) == -1) {
            model.addElement(value);
        }
    }

    public void removeItem(String value) {
        DefaultListModel model = (DefaultListModel)jList.getModel();
        model.removeElement(value);
    }

    public void setItems(String[] items) {
        DefaultListModel model = (DefaultListModel)jList.getModel();
        model.clear();
        for (int i=0; i<items.length; i++) {
            model.addElement(items[i]);
        } // end of for (int i=0; i<items.length; i++)
    }

    public int indexOf(String item) {
        DefaultListModel model = (DefaultListModel)jList.getModel();
        return model.indexOf(item);
    }

    public void setSelectedIndex(int i) {
        jList.setSelectedIndex(i);
    }
    public void selectAll() {
        DefaultListModel model = (DefaultListModel)jList.getModel();
        jList.addSelectionInterval(0, model.getSize()-1);
    }

    /**
     * Method setSelectedIndices
     *
     * @param    selectedIndices     an int[]
     *
     */
    public void setSelectedIndices(int[] selectedIndices) {
        DefaultListModel model = (DefaultListModel)jList.getModel();
        jList.setSelectedIndices(selectedIndices);
    }

    public void showDialog() {
        this.setSize(new java.awt.Dimension(400,400));
        this.setVisible(true);
    }

    public void closeDialog() {

        this.setVisible(false);
    }


    public String getSelectedValue() {

        return (String)jList.getSelectedValue();
    }

    public String[] getSelectedValues() {

        Object[] values = jList.getSelectedValues();
        String[] rtn = new String[values.length];
        for(int counter = 0; counter < values.length; counter++) {

            rtn[counter] = (String) values[counter];
        }
        return rtn;
    }

    private JPanel panel;

    private JPanel toolPanel;

    private JList jList;

    private JTextField textField;// = new JTextField();

    private JButton addButton;// = new JButton("Add");

    private JButton closeButton;

    private DefaultListModel listModel = new DefaultListModel();
}// CheckBoxDialog
