package edu.sc.seis.gee.task;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import com.bbn.openmap.LatLonPoint;
import edu.iris.Fissures.Area;
import edu.iris.Fissures.model.BoxAreaImpl;

/**
 * BoxAreaDisplay.java Created: Mon Jan 14 10:47:37 2002
 * 
 * @author <a href="mailto:">Srinivasa Telukutla </a>
 * @version
 */
public class BoxAreaDisplay extends JPanel {

    public BoxAreaDisplay() {
        this(-90, -180, 90, 180);
    }

    public BoxAreaDisplay(int minlat, int minlon, int maxlat, int maxlon) {
        this(minlat, minlon, maxlat, maxlon, null);
    }

    public BoxAreaDisplay(int minlat, int minlon, int maxlat, int maxlon,
            final OpenMapTask mapTask) {
        minLatCtrl = new JSpinner(new SpinnerNumberModel(minlat, -90, 90, 20));
        minLonCtrl = new JSpinner(new SpinnerNumberModel(minlon, -180, 180, 40));
        maxLatCtrl = new JSpinner(new SpinnerNumberModel(maxlat, -90, 90, 20));
        maxLonCtrl = new JSpinner(new SpinnerNumberModel(maxlon, -180, 180, 40));
        setBorder(new TitledBorder("Area"));
        GridBagLayout gridLayout = new GridBagLayout();
        setLayout(gridLayout);
        GridBagConstraints constraints = new GridBagConstraints();
        final JButton worldwide = new JButton("Entire World");
        worldwide.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                setAreaWorldwide();
            }
        });
        constraints.insets = new Insets(2, 5, 2, 5);
        if(mapTask != null) {
            final JButton fromMap = new JButton("From Map");
            fromMap.addActionListener(new ActionListener() {

                public void actionPerformed(ActionEvent e) {
                    LatLonPoint upperLeft = mapTask.getUpperLeftCorner();
                    maxLatCtrl.setValue(new Integer((int)upperLeft.getLatitude()));
                    minLonCtrl.setValue(new Integer((int)upperLeft.getLongitude()));
                    LatLonPoint lowerRight = mapTask.getLowerRightCorner();
                    minLatCtrl.setValue(new Integer((int)lowerRight.getLatitude()));
                    maxLonCtrl.setValue(new Integer((int)lowerRight.getLongitude()));
                }
            });
            gridLayout.setConstraints(worldwide, constraints);
            add(worldwide);
            constraints.gridy = 1;
            constraints.gridx = 0;
            gridLayout.setConstraints(fromMap, constraints);
            add(fromMap);
            constraints.gridheight = 2;
        } else {
            constraints.gridheight = 2;
            gridLayout.setConstraints(worldwide, constraints);
            add(worldwide);
            constraints.gridheight = 1;
        }
        JPanel controls = makeLatLonSetters();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.ipadx = 0;
        gridLayout.setConstraints(controls, constraints);
        add(controls);
    }

    private void setAreaWorldwide() {
        minLatCtrl.setValue(new Integer(-90));
        minLonCtrl.setValue(new Integer(-180));
        maxLatCtrl.setValue(new Integer(90));
        maxLonCtrl.setValue(new Integer(180));
    }

    private JPanel makeLatLonSetters() {
        JPanel displayPanel = new JPanel();
        GridBagLayout gridLayout = new GridBagLayout();
        displayPanel.setLayout(gridLayout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = GridBagConstraints.HORIZONTAL;
        JLabel minLabel = new JLabel("Minimum");
        constraints.gridx = 1;
        gridLayout.setConstraints(minLabel, constraints);
        displayPanel.add(minLabel);
        JLabel maxLabel = new JLabel("Maximum");
        constraints.gridx = 2;
        gridLayout.setConstraints(maxLabel, constraints);
        displayPanel.add(maxLabel);
        JLabel latLabel = new JLabel("Latitude");
        constraints.gridx = 0;
        constraints.gridy = 1;
        gridLayout.setConstraints(latLabel, constraints);
        displayPanel.add(latLabel);
        constraints.gridx = 1;
        gridLayout.setConstraints(minLatCtrl, constraints);
        displayPanel.add(minLatCtrl);
        constraints.gridx = 2;
        gridLayout.setConstraints(maxLatCtrl, constraints);
        displayPanel.add(maxLatCtrl);
        JLabel lonLabel = new JLabel("Longitude");
        constraints.gridy = 2;
        constraints.gridx = 0;
        gridLayout.setConstraints(lonLabel, constraints);
        displayPanel.add(lonLabel);
        constraints.gridx = 1;
        gridLayout.setConstraints(minLonCtrl, constraints);
        displayPanel.add(minLonCtrl);
        constraints.gridx = 2;
        gridLayout.setConstraints(maxLonCtrl, constraints);
        displayPanel.add(maxLonCtrl);
        return displayPanel;
    }

    private static int getInt(Object o) {
        return ((Integer)o).intValue();
    }

    public Area getArea() {
        int minLat = getInt(minLatCtrl.getValue());
        int maxLat = getInt(maxLatCtrl.getValue());
        int minLon = getInt(minLonCtrl.getValue());
        int maxLon = getInt(maxLonCtrl.getValue());
        return new BoxAreaImpl(minLat, maxLat, minLon, maxLon);
    }

    private JSpinner minLatCtrl, maxLatCtrl, minLonCtrl, maxLonCtrl;
}// BoxAreaDisplay
