package edu.sc.seis.gee.task;

import java.util.HashMap;
import java.util.Iterator;

/**
 * AllTasks.java Created: Fri Nov 30 11:46:30 2001
 * 
 * @author <a href="mailto:">Philip Crotwell </a>
 * @version $Id: AllTasks.java 11394 2004-12-07 22:27:52Z oliverpa $
 */
public class AllTasks {

    private AllTasks() {}

    public static void assoicateTaskActionWithId(TaskAction t) {
        idToTaskAction.put(t.getId(), t);
    }

    /**
     * After a TaskAction has created its task, it uses this method so that all
     * instantiated tasks can get their task action
     */
    public static void associateTaskWithTaskAction(TaskAction ta, Task t) {
        taskToAction.put(t, ta);
    }

    /** gets the TaskAction for the given id, null if it cannot be found. */
    public static TaskAction getTaskAction(String id) {
        return (TaskAction)idToTaskAction.get(id);
    }

    /** gets the TaskAction for the given Task */
    public static TaskAction getTaskAction(Task t) {
        return (TaskAction)taskToAction.get(t);
    }
    
    public static Task getTask(String id){
        return (Task)idToTask.get(id);
    }
    
    public static void associateTaskWithId(String id, Task t){
        idToTask.put(id, t);
    }
    
    

    public static void resetAll() {
        Iterator it = idToTaskAction.keySet().iterator();
        while(it.hasNext()) {
            TaskAction t = (TaskAction)idToTaskAction.get(it.next());
            t.reset();
        } // end of while (it.hasNext())
    }

    public static void clear() {
        idToTaskAction.clear();
        taskToAction.clear();
        idToTask.clear();
    }

    private static HashMap idToTaskAction = new HashMap();

    private static HashMap taskToAction = new HashMap();
    
    private static HashMap idToTask = new HashMap();
}// AllTasks
