/**
 * AddFriends.java
 *
 * @author Created by Omnicore CodeGuide
 */

package edu.sc.seis.gee.task;
import java.util.Map;
import org.apache.log4j.Logger;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;



public class AddFriends implements Task{
    public void invoke() throws Exception {
        ColumnSeismogramTask colSeis = (ColumnSeismogramTask)colSeisTA.getTask();
        DataSetSeismogram[] dataSetSeis = colSeis.getDisplay().getSeismograms();
        for (int i = 0; i < dataSetSeis.length; i++) {
            DataSetSeismogram[] components = DisplayUtils.getComponents(dataSetSeis[i]);
            logger.debug("got "+components.length+" friends");
            for (int j = 0; j < components.length; j++) {
                if ( ! components[j].equals(dataSetSeis[i])) {
                    logger.debug("dss friend:"+ChannelIdUtil.toString(components[j].getRequestFilter().channel_id));
                    colSeis.addSeismogram(components[j]);
                } else {
                    logger.debug("existing dss:"+ChannelIdUtil.toString(components[j].getRequestFilter().channel_id));
                }
            }
        }
    }

    public void destroy() { }

    public void configure(Map params) throws ConfigurationException {
        if(params.containsKey(COL_SEIS_ID)){
            colSeisTA = CommonAccess.getCommonAccess().getTaskAction((String)params.get(COL_SEIS_ID));
        }else{
            throw new ConfigurationException("An add friends task needs a display for adding friends");
        }
    }

    TaskAction colSeisTA;

    private static final String COL_SEIS_ID = "ColumnSeismogramTask";

    private static final Logger logger = Logger.getLogger(AddFriends.class);


}


