package edu.sc.seis.gee.configurator;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import edu.sc.seis.gee.task.AllTasks;
import edu.sc.seis.gee.task.TaskAction;

/**
 * ToolItemHandler.java
 *
 *
 * Created: Wed Nov 28 16:15:04 2001
 *
 * @author <a href="mailto:">Philip Crotwell</a>
 * @version
 */

public class ToolItemHandler extends AbstractHandler implements ToolBarItem {
    public ToolItemHandler (org.xml.sax.XMLReader parser,
                AbstractHandler parent){
    super(parser, parent);
    }

    public void startElement(String namespaceURI,
                 String localName,
                 String qName,
                 Attributes atts) {
    //System.out.println(localName);
    if (localName.equals("taskid")) {
        parser.setContentHandler(new ToolItemHandler.TaskIdHandler(parser,
                                       this));
    }

    }

    public TaskAction getToolItem() throws ConfigurationException {
    if (taskid.length() != 0 && AllTasks.getTaskAction(taskid) != null) {
        return AllTasks.getTaskAction(taskid);
    } // end of if (taskid.length() != 0)
    throw new ConfigurationException("Can't find task "+taskid);
    }

    String taskid = "";

    class TaskIdHandler extends AbstractHandler {
    TaskIdHandler(org.xml.sax.XMLReader parser,
             AbstractHandler parent){
        super(parser, parent);
    }

    public void characters(char[] ch,
                   int start,
                   int length)
        throws SAXException {
        taskid +=  new String(ch, start, length);
    }
    }
}
