package edu.sc.seis.gee.configurator;

import java.util.LinkedList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/**
 * ToolbarHandler.java
 *
 *
 * Created: Wed Nov 28 16:15:04 2001
 *
 * @author <a href="mailto:">Philip Crotwell</a>
 * @version
 */

public class ToolBarHandler extends AbstractHandler {
    public ToolBarHandler (org.xml.sax.XMLReader parser,
               AbstractHandler parent){
    super(parser, parent);
    }

    public void startElement(String namespaceURI,
                 String localName,
                 String qName,
                 Attributes atts) {
    //System.out.println(localName);
    if (localName.equals("name")) {
        parser.setContentHandler(new ToolBarHandler.NameHandler(parser,
                                 this));
    } else if (localName.equals("toolitem")) {
        ToolItemHandler handler = new ToolItemHandler(parser, this);
        parser.setContentHandler(handler);
        toolItem.add(handler);
    } else if (localName.equals("menu")) {
        MenuHandler handler = new MenuHandler(parser, this);
        parser.setContentHandler(handler);
        toolItem.add(handler);
    }

    }

    public ToolBarItem[] getToolItems() throws ConfigurationException {
    ToolBarItem[] items = new ToolBarItem[toolItem.size()];
    return (ToolBarItem[])toolItem.toArray(items);
    }

    String name = "";
    LinkedList toolItem = new LinkedList();

    class NameHandler extends AbstractHandler {
    NameHandler(org.xml.sax.XMLReader parser,
             AbstractHandler parent){
        super(parser, parent);
    }

    public void characters(char[] ch,
                   int start,
                   int length)
        throws SAXException {
        name +=  new String(ch, start, length);
    }
    }
}
