package edu.sc.seis.gee.configurator;

import java.util.LinkedList;
import org.xml.sax.Attributes;

/**
 * GeeConfigHandler.java Created: Wed Nov 28 16:07:45 2001
 * 
 * @author <a href="mailto:">Philip Crotwell </a>
 * @version
 */
public class GeeConfigHandler extends AbstractHandler {

    public GeeConfigHandler(org.xml.sax.XMLReader parser) {
        super(parser, (AbstractHandler)null);
    }

    public void startElement(String namespaceURI,
                             String localName,
                             String qName,
                             Attributes atts) {
        if(localName.equals("activity")) {
            ActivityHandler handler = new ActivityHandler(parser, this);
            parser.setContentHandler(handler);
            activity.add(handler);
        } else if(localName.equals("title")) {
            parser.setContentHandler(new GeeConfigHandler.TitleHandler(parser,
                                                                       this));
        } else if(localName.equals("appendConfig")) {
            AppendConfigHandler handler = new AppendConfigHandler(parser, this);
            appendConfigs.add(handler);
            parser.setContentHandler(handler);
        } else if(localName.equals("task")) {
            TaskHandler handler = new TaskHandler(parser, this);
            parser.setContentHandler(handler);
            task.add(handler);
        }else if(localName.equals("appendToTask")){
            TaskHandler handler = new AppendTaskHandler(parser, this);
            parser.setContentHandler(handler);
            task.add(handler);
        }
    }

    public ActivityHandler[] getActivities() {
        ActivityHandler[] act = new ActivityHandler[activity.size()];
        return (ActivityHandler[])activity.toArray(act);
    }

    public AppendConfigHandler[] getAppendConfigs() {
        return (AppendConfigHandler[])appendConfigs.toArray(new AppendConfigHandler[0]);
    }

    public TaskHandler[] getTasks() {
        return (TaskHandler[])task.toArray(new TaskHandler[0]);
    }

    public String getTitle() {
        return title;
    }

    LinkedList appendConfigs = new LinkedList();

    LinkedList activity = new LinkedList();

    String title = "";

    LinkedList task = new LinkedList();

    class TitleHandler extends AbstractHandler {

        TitleHandler(org.xml.sax.XMLReader parser, AbstractHandler parent) {
            super(parser, parent);
        }

        public void characters(char[] ch, int start, int length) {
            title += new String(ch, start, length);
        }
    }

    public void appendActivites(ActivityHandler[] activities) {
        for(int i = 0; i < activities.length; i++) {
            activity.add(activities[i]);
        }
    }
}// GeeConfigHandler
