package edu.sc.seis.gee.configurator;

import java.util.HashMap;
import org.xml.sax.XMLReader;
import edu.sc.seis.gee.task.AllTasks;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;

/**
 * @author groves Created on Dec 6, 2004
 */
public class AppendTaskHandler extends TaskHandler {

    public AppendTaskHandler(XMLReader parser, AbstractHandler parent) {
        super(parser, parent);
    }
    
    public void setTaskInstance(Task t){
        super.setTaskInstance(t);
        AllTasks.associateTaskWithId(id, t);
    }

    public TaskAction getTaskAction() throws ConfigurationException {
        TaskAction t = AllTasks.getTaskAction(id);
        if(t == null) { throw new ConfigurationException("Append task of id "
                + id + " reached before base task loaded"); }
        HashMap originalParams = (HashMap)(t.getConfigParams()).clone();
        configParam.put(DISPLAY_LOCATION, originalParams.get(DISPLAY_LOCATION));
        if(name.equals("")) {
            name = (String)originalParams.get(TASK_NAME);
        }
        classname = (String)originalParams.get(TASK_CLASSNAME);
        if(tooltip.equals("") && originalParams.containsKey(TOOLTIP)) {
            tooltip = (String)originalParams.get(TOOLTIP);
        }
        task = (Task)originalParams.get(TASK_INSTANCE);
        if(!toggle) {
            toggle = t.isToggle();
        }
        if(iconName.equals("")) {
            iconName = t.getIconLoc();
        }
        if(toolbar == null) {
            toolbar = t.getToolBarHandler();
        }
        finished();
        originalParams.putAll(configParam);
        configParam = originalParams;
        return  super.getTaskAction();
    }
}