package edu.sc.seis.gee.configurator;

import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JMenuBar;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/**
 * ActivityHandler.java
 *
 *
 * Created: Wed Nov 28 16:15:04 2001
 *
 * @author <a href="mailto:">Philip Crotwell</a>
 * @version
 */

public class ActivityHandler extends AbstractHandler {
    public ActivityHandler (org.xml.sax.XMLReader parser,
                AbstractHandler parent){
    super(parser, parent);
    }

    public void startElement(String namespaceURI,
                 String localName,
                 String qName,
                 Attributes atts) {
    //  System.out.println(localName);
    if (localName.equals("title")) {
        parser.setContentHandler(new ActivityHandler.TitleHandler(parser,
                                      this));
    } else if (localName.equals("id")) {
        parser.setContentHandler(new ActivityHandler.IdHandler(parser,
                                        this));
    } else if (localName.equals("description")) {
        parser.setContentHandler(new ActivityHandler.DescriptionHandler(parser,
                                        this));
    } else if (localName.equals("appendActivityId")) {
        parser.setContentHandler( new AppendActivityHandler(parser, this));
    } else if (localName.equals("menubar")) {
        menubar = new MenuBarHandler(parser, this);
        parser.setContentHandler(menubar);

    } else if (localName.equals("initialTask")) {
        InitialTaskHandler handle = new InitialTaskHandler(parser, this);
        parser.setContentHandler(handle);
        initialTasks.add(handle);
    } else if (localName.equals("inactiveTask")) {
        InactiveTaskHandler handle = new InactiveTaskHandler(parser, this);
        parser.setContentHandler(handle);
        inactiveTasks.add(handle);
     } else if (localName.equals("exceptionGreeting")) {
        ExceptionGreetingHandler handle = new ExceptionGreetingHandler(parser, this);
        parser.setContentHandler(handle);
    }

    }

    public JMenuBar getMenuBar()  throws ConfigurationException {
        if (menubar == null) {
            return EMPTY_MENU;
        }

        return menubar.getMenuBar();
    }

    public String[] getInitialTasks()  throws ConfigurationException {
    String[] out = new String[initialTasks.size()];
    Iterator it = initialTasks.iterator();
    int i=0;
    while (it.hasNext()) {
        InitialTaskHandler handler = (InitialTaskHandler)it.next();
        out[i++] = handler.getTaskId();
    } // end of while (it.hasNext())

    return out;
    }

    public String[] getInactiveTasks()  throws ConfigurationException {
    String[] out = new String[inactiveTasks.size()];
    Iterator it = inactiveTasks.iterator();
    int i=0;
    while (it.hasNext()) {
        InactiveTaskHandler handler = (InactiveTaskHandler)it.next();
        out[i++] = handler.getTaskId();
    } // end of while (it.hasNext())

    return out;
    }

    public String getId() {
        return id;
    }

    public String getAppendActivityId() {
        return appendActivityId;
    }
    static JMenuBar EMPTY_MENU = new JMenuBar();
    String id = "";
    String title = "";
    String description = "";
    MenuBarHandler menubar;
    LinkedList initialTasks = new LinkedList();
    LinkedList inactiveTasks = new LinkedList();
    String appendActivityId = "";

    class TitleHandler extends AbstractHandler {
    TitleHandler(org.xml.sax.XMLReader parser,
             AbstractHandler parent){
        super(parser, parent);
    }

    public void characters(char[] ch,
                   int start,
                   int length)
        throws SAXException {
        title +=  new String(ch, start, length);
    }
    }

    class IdHandler extends AbstractHandler {
        IdHandler(org.xml.sax.XMLReader parser,
                  AbstractHandler parent){
            super(parser, parent);
        }

        public void characters(char[] ch,
                               int start,
                               int length)
            throws SAXException {
            id +=  new String(ch, start, length);
        }
    }

    class AppendActivityHandler extends AbstractHandler {
        AppendActivityHandler(org.xml.sax.XMLReader parser,
                  AbstractHandler parent){
            super(parser, parent);
        }

        public void characters(char[] ch,
                               int start,
                               int length)
            throws SAXException {
            appendActivityId +=  new String(ch, start, length);
        }
    }

    class DescriptionHandler extends AbstractHandler {
    DescriptionHandler(org.xml.sax.XMLReader parser,
               AbstractHandler parent){
        super(parser, parent);
    }

    public void characters(char[] ch,
                   int start,
                   int length)
        throws SAXException {
        description +=  new String(ch, start, length);
    }
    }
}// ActivityHandler
