package edu.sc.seis.gee.configurator;

import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * AbstractHandler.java
 *
 *
 * Created: Wed Nov 28 15:41:17 2001
 *
 * @author <a href="mailto:">Philip Crotwell</a>
 * @version
 */

public abstract class AbstractHandler extends DefaultHandler {
    public AbstractHandler (org.xml.sax.XMLReader parser, 
			    AbstractHandler parent){
	this.parent = parent;
	this.parser = parser;
    }
    
    /**
     * Called when this element and all elements nested into it have been
     * handled.
     */
    protected void finished() {};

    public void endElement(java.lang.String namespaceURI,
                       java.lang.String localName,
                       java.lang.String qName)
	throws SAXException {
	//	System.out.println("end "+localName);
	finished();
	// Let parent resume handling SAX events, unless it is null, ie root
	if (parent != null) {
	    parser.setContentHandler(parent);
	}
    }

    protected AbstractHandler parent;
    protected org.xml.sax.XMLReader parser;

}// AbstractHandler
