
package edu.sc.seis.gee;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import javax.swing.JComponent;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;


/**
 * Splash.java
 *
 *
 * Created: Thu Mar 23 22:04:28 2000
 *
 * @author Philip Crotwell
 * @version
 */

public class Splash extends JComponent {

    public Splash() {

        Class c = getClass();
        java.net.URL splashURL = c.getClassLoader().getResource(filename);
        Toolkit tk = Toolkit.getDefaultToolkit();
        logo = tk.getImage(splashURL);
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(logo, 0);
        try {
            mt.waitForID(0);
        } catch (Throwable e) {
            GlobalExceptionHandler.handle(e);
        }
    setPreferredSize(new Dimension(logo.getWidth(this),
                                       logo.getHeight(this)));

    }

    public void paintComponent(Graphics g) {
        g.drawImage(logo, 0, 0, this);
    }

    private static String filename = "edu/sc/seis/gee/data/images/gee-logo.png";
    //private static String filename = "oppy_splash.jpeg";
    //    private static String filename = "oppy_splash.png";

    protected Image logo;
} // CeeSplash
