package edu.sc.seis.gee;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: Univ of South Carolina</p>
 * @author unascribed
 * @version 1.0
 */

import java.util.StringTokenizer;
import com.ice.jni.registry.NoSuchValueException;
import com.ice.jni.registry.RegDWordValue;
import com.ice.jni.registry.RegStringValue;
import com.ice.jni.registry.Registry;
import com.ice.jni.registry.RegistryException;
import com.ice.jni.registry.RegistryKey;
import com.ice.jni.registry.RegistryValue;

/**
 * <p>Title: </p>
 * <p>Description: Class that uses JNI under windows to read the proxy server settings
 * from the windows registry</p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: </p>
 * @author unascribed
 * @version 1.0
 */

public class ProxySettings {

    boolean usesProxyServer = false;
    String ProxyServer = "0.0.0.0";
    int ProxyPort = -1;

    public ProxySettings() {

      String osName = System.getProperty("os.name");

      if (osName == null)
        return;


      if (osName.startsWith("Windows")) {
        try {
          checkProxyStatus();
        } catch (NoSuchValueException ex) {
          // if any problems, just assume no proxy
            resetForNoProxyServer();
        } catch (RegistryException ex) {
          // if any problems, just assume no proxy
            resetForNoProxyServer();
        } catch (UnsatisfiedLinkError ex) {
            // looks like we don't have the ICE dll linked
            resetForNoProxyServer();
        }
      }
    }
    
    private void resetForNoProxyServer() {
        usesProxyServer = false;
        ProxyServer = "0.0.0.0";
        ProxyPort = -1;
    }

    private boolean checkProxyEnable() throws NoSuchValueException, RegistryException {
      int				index;
      RegistryKey		key;
      RegistryKey		subKey;
      RegistryKey		topKey = null;
      boolean			isRemote = false;
      String			topKeyName = "HKCU";
      String			hostName = null;

      //    System.out.println("topKeyName is >" + topKeyName +"<");
      topKey = Registry.getTopLevelKey( topKeyName );

      subKey = Registry.openSubkey( topKey, "software\\microsoft\\windows\\currentversion\\internet settings",
                                    RegistryKey.ACCESS_READ );
      if ( subKey == null )
        return this.usesProxyServer;;

      RegistryValue	data = null;
      String valueName = "ProxyEnable";

      data = subKey.getValue( valueName );

      if ( data instanceof RegDWordValue ) {
        RegDWordValue val = (RegDWordValue) data;

        if (val.getData() == 1) {
          this.usesProxyServer = true;
        }
      }

      return this.usesProxyServer;

    }

    private void getProxyInfo() throws NoSuchValueException, RegistryException {

      int				index;
      RegistryKey		key;
      RegistryKey		subKey;
      RegistryKey		topKey = null;
      boolean			isRemote = false;
      String			topKeyName = "HKCU";
      String			hostName = null;

      String valueName = "ProxyServer";
      RegistryValue	data = null;

      topKey = Registry.getTopLevelKey( topKeyName );

      subKey = Registry.openSubkey( topKey, "software\\microsoft\\windows\\currentversion\\internet settings",
                                    RegistryKey.ACCESS_READ );
      if ( subKey == null )
        return;

      data = subKey.getValue( valueName );


      if ( data instanceof RegStringValue )
      {
        RegStringValue val = (RegStringValue) data;

        // parse the proxyhost and port from the data.
        String retVal = val.getData();

        StringTokenizer st = new StringTokenizer(retVal, ":");
        while (st.hasMoreTokens()) {
          ProxyServer = st.nextToken();
          String port = st.nextToken();
          ProxyPort = Integer.parseInt(port);
        }
      }

    }

    private void checkProxyStatus() throws NoSuchValueException, RegistryException {

      this.checkProxyEnable();
      this.getProxyInfo();

    }


    /**
     * check the setting for the Proxy Server's usage
     * @return true if windows is using the proxy server.
     */
    public boolean usesProxy() {
      return this.usesProxyServer;
    }

    /**
     * check the setting for the Proxy Server's Port
     * @return the port number
     */
    public int getProxyPort() {
      return this.ProxyPort;
    }

    /**
     * check the setting for the Proxy Server's IP address.
     * @return a String containing the IP address or fully qualified hostname
     */
    public String getProxyServer() {
      return this.ProxyServer;
    }

    /**
     * summarize the Proxy Status.
     * @return a string representing the proxy server overall status.
     */
    public String toString() {
      StringBuffer ret = new StringBuffer();
      if (usesProxy() ) {
        ret.append("Using Proxy Server\n");
      } else {
        ret.append("Not Using Proxy Server\n");
      }
      ret.append("ProxyServer is " + ProxyServer + "\n");
      ret.append("ProxyPort is " + ProxyPort + "\n");
      return ret.toString();
    }

    public static void main(String[] args) {
      ProxySettings ps = new ProxySettings();
    }
}
