/**
 * NetworkGateKeeper.java
 *
 * @author Created by Omnicore CodeGuide
 */

package edu.sc.seis.gee;
import javax.swing.JOptionPane;
import org.omg.CORBA.SystemException;
import edu.sc.seis.fissuresUtil.exceptionHandler.ExceptionInterceptor;
import edu.sc.seis.fissuresUtil.netConnChecker.Checker;
import edu.sc.seis.fissuresUtil.netConnChecker.ConnStatus;
import edu.sc.seis.fissuresUtil.netConnChecker.CorbaChecker;



public class NetworkGateKeeper {

    public synchronized static boolean corbaAccessAllowed() {
        if (corbaOffline || ! accessAllowed()) {
            return false;
        }
        Checker checker = CommonAccess.getCommonAccess().getChecker();
        ConnStatus status = checker.getStatus(CorbaChecker.class);

        if (status.equals(ConnStatus.SUCCESSFUL)) {
            return true;
        } else if (status.equals(ConnStatus.FAILED) || status.equals(ConnStatus.TRYING)) {
            askForCorbaRetry(checker);
        }
        return ! corbaOffline;
    }

    private static void askForCorbaRetry(Checker checker) {
        ConnStatus status;
        Object[] options = {"Keep Trying", "Offline"};
        int n = JOptionPane.showOptionDialog(FrameManager.getManager().getCurrentFrame(),
                                             NoNetworkException.noNetworkMessage+" Would you like to retry or go offline?",
                                             "Network Unavailable",
                                             JOptionPane.YES_NO_OPTION,
                                             JOptionPane.QUESTION_MESSAGE,
                                             null,     //don't use a custom Icon
                                             options,  //the titles of buttons
                                             options[0]); //default button title
        if (n == JOptionPane.YES_OPTION) {
            CommonAccess.getCommonAccess().getChecker().runChecks();
            // sleep for 5 second before rechecking
            try {
                Thread.sleep(5000);
            } catch (InterruptedException e) {}
            status = checker.getStatus(CorbaChecker.class);
            if (status.equals(ConnStatus.FAILED) || status.equals(ConnStatus.TRYING)) {
                JOptionPane.showMessageDialog(FrameManager.getManager().getCurrentFrame(),
                                              "Corba is not available, GEE will now go offline.",
                                              "Network Connection", JOptionPane.ERROR_MESSAGE);
                corbaOffline = true;
                System.setProperty("edu.sc.seis.gee.corbaOffline", ""+corbaOffline);
            }
        } else {
            offline = true;
            System.setProperty("edu.sc.seis.gee.corbaOffline", ""+corbaOffline);
        }
    }
    
    public static class SystemExceptionInterceptor implements ExceptionInterceptor{

        public boolean handle(String message, Throwable t) {
            if(t instanceof SystemException && !offline && !corbaOffline){
                JOptionPane.showMessageDialog(FrameManager.getManager().getCurrentFrame(),
                                              "GEE's servers are unavailable.  Try again in a few minutes.",
                                              "Server Error", JOptionPane.ERROR_MESSAGE);
                return true;
            }
            return false;
        }
    }

    public synchronized static boolean accessAllowed() {
        if (offline) {
            return false;
        }
        ConnStatus status = CommonAccess.getCommonAccess().getNetworkStatus();
        if (status.equals(ConnStatus.SUCCESSFUL)) {
            return true;
        } else if (status.equals(ConnStatus.FAILED) || status.equals(ConnStatus.TRYING)) {
            Object[] options = {"Keep Trying", "Offline"};
            int n = JOptionPane.showOptionDialog(FrameManager.getManager().getCurrentFrame(),
                                                 "There seems to be a problem with the network. Would you like to retry or go offline?",
                                                 "Network Unavailable",
                                                 JOptionPane.YES_NO_OPTION,
                                                 JOptionPane.QUESTION_MESSAGE,
                                                 null,     //don't use a custom Icon
                                                 options,  //the titles of buttons
                                                 options[0]); //default button title
            if (n == JOptionPane.YES_OPTION) {
                CommonAccess.getCommonAccess().getChecker().runChecks();
                // sleep for 1 second before rechecking
                try {
                    Thread.sleep(5000);
                } catch (InterruptedException e) {}
                status = CommonAccess.getCommonAccess().getNetworkStatus();
                if (status.equals(ConnStatus.FAILED) || status.equals(ConnStatus.TRYING)) {
                    JOptionPane.showMessageDialog(FrameManager.getManager().getCurrentFrame(),
                                                  "The network is not available, GEE will now go offline.",
                                                  "Network Connection", JOptionPane.ERROR_MESSAGE);
                    offline = true;
                    System.setProperty("edu.sc.seis.gee.offline", ""+offline);
                }
            } else {
                offline = true;
                System.setProperty("edu.sc.seis.gee.offline", ""+offline);
            }
        }
        return ! offline;
    }

    public static boolean isOffline() {
        return offline;
    }


    public static boolean isCorbaOffline() {
        return offline;
    }

    private static boolean offline = false;

    private static boolean corbaOffline = false;

    static {
        System.setProperty("edu.sc.seis.gee.connChecker.offline", ""+offline);
        System.setProperty("edu.sc.seis.gee.connChecker.corbaOffline", ""+corbaOffline);
    }
}

