from gee.test.Jytest import Jytest
from gee.event.EventTable import RegionColumn, DataModel, ColumnModel, EventTable
from gee.event.EventDB import EventDB
from edu.sc.seis.fissuresUtil.flow import Message
from gee.test.event.EventServerTest import MessageCounter
from edu.sc.seis.fissuresUtil.mockFissures.IfEvent import MockEventAccessOperations
from edu.sc.seis.fissuresUtil.flow.extractor.event import RegionNameExtractor

class DataModelTest(Jytest):
    def __init__(self, name): 
        Jytest.__init__(self, name)
    
    def testAdditionPropogation(self):
        events = EventDB()
        dm = DataModel(events, ColumnModel())
        mc = MessageCounter()
        dm.addTableModelListener(mc)
        events.send(Message('test'))
        self.assertTrue(mc.count > 0)

    def testTableModelMethods(self):
        events = EventDB()
        for event in MockEventAccessOperations.createEvents():
            events.receive(Message(event))
        dm = DataModel(events, ColumnModel())
        self.assertEquals(len(events), dm.getRowCount())
        self.assertEquals(RegionNameExtractor().extract(events[0]),
                dm.getValueAt(0, 0))
                
class SelectionTest(Jytest):
    def __init__(self, name): 
        Jytest.__init__(self, name)
    
    def testSelectionShowsUpInSelectionList(self):
        events = EventDB()
        for event in MockEventAccessOperations.createEvents():
            events.receive(Message(event))
        table = EventTable(events)
        table.setRowSelectionInterval(1, 1)
        self.assertEquals(1, len(table.selection))
        self.assertEquals(events[1], table.selection[0])
        table.addRowSelectionInterval(0, 0)
        self.assertEquals(2, len(table.selection))
        for event in table.selection:
            self.assertTrue(event in events)
