from gee.test.Jytest import Jytest
from edu.sc.seis.fissuresUtil.mockFissures.IfEvent import MockEventAccessOperations, MockEventFinder
from gee.event.EventServer import EventServer
from edu.sc.seis.fissuresUtil.flow import Receiver
from javax.swing.event import TableModelListener

class MessageCounter(Receiver, TableModelListener):
    def __init__(self):
        self.count = 0
    
    def receive(self, message):
        self.count += 1

    def tableChanged(self, event):
        self.count += 1

class EventServerTest(Jytest):
    def __init__(self, name): 
        Jytest.__init__(self, name)

    def testWideOpen(self):
        counter = MessageCounter()
        events = MockEventAccessOperations.createEvents()
        server = EventServer(MockEventFinder(events), receiver=counter)
        server.run()
        self.assertEquals(len(events), counter.count)
        
